#ifndef _COORDS_HH_
#define _COORDS_HH_

#include <stdio.h>

#include "expr.hh"

class Coords {
  private:
	Expr x, y;

  public:
	Coords(Expr &xp, Expr &yp) :
	  x(xp), y(yp)
	{}

	// accessors and mutators
	void set_x(Expr &xp)
	{
		x = xp;
	}
	
	void set_y(Expr &yp)
	{
		y = yp;
	}
	
	Expr &get_x()
	{
		return x;
	}
	
	Expr &get_y()
	{
		return y;
	}
	
	// print function
	void print(FILE *ofile)
	{
		fprintf(ofile, "( ");
		x.print(ofile);
		fprintf(ofile, ", ");
		y.print(ofile);
		fprintf(ofile, ")");
	}
};

#endif
