// generated 2003/9/27 13:29:37 MDT by pfeiffer@valiant.cs.fiu.edu
// using glademm V2.0.0
//
// newer (non customized) versions of this file go to colorselectiondialog1.cc_new

// This file is for your program, I won't touch it again!
#include <stdio.h>

#if defined __GNUC__ && __GNUC__ < 3
#error This program will crash if compiled with g++ 2.x
// see the dynamic_cast bug in the gtkmm FAQ
#endif //
#include "config.h"
#include <libgnome/libgnome.h>
#include <gdk/gdkkeysyms.h>
#include <gtkmm/accelgroup.h>
#include <gtkmm/button.h>
#include <gtkmm/colorselection.h>
#include "colorbutton.hh"
#include "colorselectiondialog1.hh"
#include "window1.hh"

colorselectiondialog1::colorselectiondialog1(window1 *windowp, ModelPlane &planep, ColorButton &buttonp) :
  Gtk::ColorSelectionDialog(_("Select Color")),
  window(windowp),
  plane(planep),
  button(buttonp)
{  

	int responseid;
	
   Gtk::ColorSelectionDialog *colorselectiondialog1 = this;
   gmm_data = new GlademmData(get_accel_group());
   
   set_modal(false);
   get_colorsel()->set_has_opacity_control(false);
   
   //   property_window_position().set_value(Gtk::WIN_POS_NONE);
   set_resizable(false);

   signal_response().connect(SigC::slot(*this, &colorselectiondialog1::on_colorselectiondialog1_response));
}

colorselectiondialog1::~colorselectiondialog1()
{  delete gmm_data;
}

// why, exactly, can't I manipulate colors in HSV space?
// code adapted from http://www.cs.rit.edu/~ncs/color/t_convert.html
// yeah, a later cleanup will quit calculating s and v.
void colorselectiondialog1::on_colorselectiondialog1_response(int responseid)
{
	Gdk::Color newcolor = get_colorsel()->get_current_color();
	
	hide();

	switch (responseid) {
	  case Gtk::RESPONSE_OK:
		float r, g, b;
		float min, max, delta;
		float h, s, v;

		r = newcolor.get_red();
		g = newcolor.get_green();
		b = newcolor.get_blue();
		
		min = r;
		if (g < min) min = g;
		if (b < min) min = b;
		
		max = r;
		if (max < g) max = g;
		if (max < b) max = b;

		v = max;				// v

		delta = max - min;

		if (max == 0 ) {
			// r = g = b = 0		// s = 0, v is undefined
			s = 0;
			h = 0;
		}

		s = delta / max;		// s
		if (r == max)
			h = ( g - b ) / delta;		// between yellow & magenta
		else if( g == max )
			h = 2.0 + ( b - r ) / delta;	// between cyan & yellow
		else
			h = 4.0 + ( r - g ) / delta;	// between magenta & cyan

		h *= 60;				// degrees
		if( h < 0 )
			h += 360;
		
		plane.beliefmap.setup(window->colormap, h);

		// this is weird:  if I don't try to set the color for the
		// state, it seems to work OK.  But if I set the color, I have
		// to explicitly change the state back to STATE_NORMAL (it
		// wants to go into STATE_ACTIVE).
		button.label.set_state(Gtk::STATE_NORMAL);
		button.label.modify_bg(Gtk::STATE_NORMAL, plane.beliefmap(7, 0));
		
		window->drawingarea1->draw_all();
		break;
	}
}

