#include <gtkmm/widget.h>
#include "colorbutton.hh"
#include "model.hh"
#include "window1.hh"

ColorButton::ColorButton(ModelPlane &planep, window1 *window1p) :
  label(), plane(planep), window(window1p)
{
	colorselector = new colorselectiondialog1(window, plane, *this);
	label.set_size_request(40, 20);
	label.modify_bg(Gtk::STATE_NORMAL, plane.beliefmap(7, 0));
	add(label);
	Gtk::manage(&label);
	label.show();

	set_flags(Gtk::CAN_FOCUS);
	set_relief(Gtk::RELIEF_NORMAL);
	set_mode(true);
	set_active(true);

	show();

	// the "toggled" signal tells me whether to display a layer or not
	signal_toggled().connect(SigC::slot(*this, &ColorButton::on_colorbutton_toggled));

	// I don't seem to be able to find a good "bring up the associated
	// menu" signal for a checkbutton.  So I'll need to hook up to the
	// button press event to do it.
	add_events(Gdk::BUTTON_PRESS_MASK);
	signal_button_press_event().connect(SigC::slot(*this, &ColorButton::on_button_pressed), false);
}

void ColorButton::on_colorbutton_toggled()
{
	plane.visible = get_active();
	window->drawingarea1->draw_all();
}	

bool ColorButton::on_button_pressed(GdkEventButton* event)
{
	// if it wasn't button 3, it's not my job.
	if (event->button != 3)
		return false;

	colorselector->get_colorsel()->set_current_color(plane.beliefmap(7, 0));
	colorselector->show();
	
	return true;
}
