#include <gdkmm/color.h>
#include <gdkmm/colormap.h>
#include "belmap.hh"

// This is the way it is because:  My parser is lazy, and doesn't do
// ints.  So I'll be passing floats here where any rational person
// would expect ints, and I'm converting to ints in the constructor.

// I create the colors before I realize the drawingarea that they're
// going to be hooked to, so I can't actually allocate them until
// then.  So there is a separate setup routine for that.  Also, of
// course, adding user-editabl hues means I have to be able to set
// them up again...
BelMap::BelMap() :
  Array2d<Gdk::Color>(8, 8)
{}

void BelMap::setup(Glib::RefPtr<Gdk::Colormap>& colormap, float huep)
{
	hue = huep;
	//printf("hue %f\n", hue);
	
	for (int belief = 0; belief < 8; ++belief)
		for (int disbelief = 0; belief + disbelief < 8; ++disbelief) {
			// This assigns colors as a function of belief and disbelief as in
			// the d2k2 paper.
			float belief_r = (float)belief/7.0;
			float disbelief_r = 0.5 + (float)disbelief/14.0 + belief_r/2.0;

			(*this)(belief, disbelief).set_hsv(hue, belief_r, disbelief_r);
			colormap->alloc_color((*this)(belief, disbelief), true, false);
			
			//printf("%f %f %f, %d %d:  (%d %d %d) %d\n",
			//   hue, belief_r, disbelief_r,
			//   belief, disbelief,
			//   (*this)(belief, disbelief).get_red(),
			//   (*this)(belief, disbelief).get_green(),
			//   (*this)(belief, disbelief).get_blue(),
			//   (*this)(belief, disbelief).get_pixel());
		}
}

