// template for 2D array of points for arena and model
#ifndef _ARRAY2D_HH_
#define _ARRAY2D_HH_

#include <assert.h>

template <class PointClass>
class Array2d {
  private:
	unsigned int width;
	unsigned int height;

  protected:
	PointClass *contents;
	
  public:
	Array2d<PointClass>(unsigned int widthp, unsigned int heightp) :
	  width(widthp), height(heightp)
	{
		contents = new PointClass[heightp*widthp];
	}
	
	PointClass& get_point(float xp, float yp)
	{
		int x = (int)(xp + 0.5);
		int y = (int)(yp + 0.5);
		
		assert(x >= 0);
		assert(y >= 0);
		assert(x < width);
		assert(y < height);
		
		return contents[y*width + x];
	}
	
	PointClass& operator()(unsigned int x, unsigned int y)
	{
		return get_point(x, y);
	}
	
	unsigned int get_width() {
		return width;
	}

	unsigned int get_height() {
		return height;
	}
};
#endif
