extern "C" {
#include <pbm.h>
};
#include <malloc.h>
#include <stdio.h>

#include "arena.hh"

Arena::Arena(FILE *arenafilep, int widthp, int heightp, int box_xp, int box_yp, int box_widthp, int box_heightp) :
  arenafile(arenafilep),
  box_x(box_xp), box_y(box_yp),
  box_width(box_widthp), box_height(box_heightp),
  Array2d<ArenaPoint>(widthp, heightp),
  visible(true)
{
}

void Arena::reset()
{
	int x, y;

	// Decide whether to use the default "blank with a box" or a PBM file
	if (arenafile == NULL) {
		// clear the entire arena
		for (y = 0; y < get_height(); ++y)
			for (x = 0; x < get_width(); ++x) {
				get_point(x, y).set_present(false);
			}
		
		// draw the outer walls
		for (x = 0; x < get_height(); ++x) {
			get_point(x, 0).set_present(true);
			get_point(x, get_height()-1).set_present(true);
		}
		
		for (y = 0; y < get_height(); ++y) {
			get_point(0, y).set_present(true);
			get_point(get_width()-1, y).set_present(true);
		}
		
		// put in a box
		for (y = box_y - box_height/2; y < box_y + box_height/2; ++y) {
			get_point(box_x - box_width/2, y).set_present(true);
			get_point(box_x + box_width/2 - 1, y).set_present(true);
		}
		
		for (x = box_x - box_width/2; x < box_x + box_width/2; ++x) {
			get_point(x, box_y - box_height/2).set_present(true);
			get_point(x, box_y + box_height/2 - 1).set_present(true);
		}
	} else {
		bit *bitrow;
		int width, height, format;

		rewind(arenafile);
		pbm_readpbminit(arenafile, &width, &height, &format);
		assert(width == get_width());
		assert(height == get_height());
		
		bitrow = (bit *)malloc(get_width() * sizeof(bit));
		for (int y = get_height() - 1; y >= 0; y--) {
			pbm_readpbmrow(arenafile, bitrow, get_width(), format);
			for (int x = 0; x < get_width(); x++)
				if (bitrow[x] == PBM_BLACK)
					get_point(x, y).set_present(true);
				else
					get_point(x, y).set_present(false);
		}
		free(bitrow);
	}
}

			

		

		
	
