/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.CompoundTerm;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;

public class EXDROutputStream
extends FilterOutputStream {
    DataOutputStream out;
    ByteArrayOutputStream buf = new ByteArrayOutputStream();

    public EXDROutputStream(OutputStream outputStream) {
        super(outputStream);
        this.out = new DataOutputStream(this.buf);
    }

    public void flush() throws IOException {
        this.flush_buffer();
        ((FilterOutputStream)this).out.flush();
    }

    private void flush_buffer() throws IOException {
        ((FilterOutputStream)this).out.write(this.buf.toByteArray());
        this.buf.reset();
    }

    public synchronized void write(Object object) throws IOException {
        this.writeVersion();
        this.writeSub(object);
        this.flush_buffer();
    }

    void writeDouble(double d) throws IOException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("NaN cannot be written in EXDR format.");
        }
        this.out.writeByte(68);
        this.out.writeDouble(d);
    }

    void writeInt(int n) throws IOException {
        this.out.writeByte(73);
        this.out.writeInt(n);
    }

    void writeList(Collection collection) throws IOException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.out.writeByte(91);
            this.writeSub(iterator.next());
        }
        this.out.writeByte(93);
    }

    void writeLong(long l) throws IOException {
        if (l == (long)((int)l)) {
            this.writeInt((int)l);
        } else {
            this.out.writeByte(74);
            this.out.writeLong(l);
        }
    }

    void writeString(String string) throws IOException {
        this.out.writeByte(83);
        this.out.writeInt(string.length());
        this.out.writeBytes(string);
    }

    void writeStructure(CompoundTerm compoundTerm) throws IOException {
        this.out.writeByte(70);
        this.out.writeInt(compoundTerm.arity());
        this.writeString(compoundTerm.functor());
        int n = 1;
        while (n <= compoundTerm.arity()) {
            this.writeSub(compoundTerm.arg(n));
            ++n;
        }
    }

    void writeSub(Object object) throws IOException {
        if (object == null) {
            this.writeVar();
        } else if (object instanceof Collection) {
            this.writeList((Collection)object);
        } else if (object instanceof CompoundTerm) {
            this.writeStructure((CompoundTerm)object);
        } else if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof Float) {
            this.writeDouble(((Float)object).doubleValue());
        } else if (object instanceof String) {
            this.writeString((String)object);
        } else {
            throw new IllegalArgumentException("Attempt to write EXDR for non-recognised class " + object.getClass().getName());
        }
    }

    void writeVar() throws IOException {
        this.out.writeByte(95);
    }

    private void writeVersion() throws IOException {
        this.out.writeByte(86);
        this.out.writeByte(1);
    }
}

