#
# $Id: eclipse_arch.tcl,v 1.1 2001/10/31 20:02:13 js10 Exp $
#
# compute the ECLiPSe architecture name using Tcl primitives
#

proc ec_arch {} {
    global tcl_platform
    switch -glob $tcl_platform(os) {
	Windows* {
	    return i386_nt
	}
	SunOS {
	    switch -glob $tcl_platform(osVersion) {
		4.*	{ return sun4 }
		5.*	{ return sparc_sunos5 }
	    }
	}
	Linux {
	    switch -glob $tcl_platform(machine) {
		alpha	{ return alpha_linux }
		i?86	{ return i386_linux }
	    }
	}
    }
    error "Platform $tcl_platform(os) $tcl_platform(osVersion) ($tcl_platform(machine)) not supported"
}

