% ----------------------------------------------------------------------
% System:	ECLiPSe Constraint Logic Programming System
% Copyright (C) Imperial College London and ICL 1995-1999
% Version:	$Id: apply.pl,v 1.4 2000/05/05 14:57:49 js10 Exp $
% ----------------------------------------------------------------------

%
% SEPIA PROLOG LIBRARY MODULE
%
% sccsid("%W%             %E%").
% sccscr("%Z%  Copyright 1991 ECRC GmbH ").
%
% IDENTIFICATION:       apply.pl
%
% AUTHOR:               Joachim Schimpf
%
% CONTENTS:             apply/2,3
%

:- module(apply).
:- export apply/2.
:- export apply/3.

:- comment(summary, "Contains the apply/2 predicate").
:- comment(copyright, "Imperial College London and ICL").
:- comment(author, "Joachim Schimpf, ECRC Munich").
:- comment(date, "$Date: 2000/05/05 14:57:49 $").

:- tool(apply/2, apply/3).

apply(Term, AddArgs, Module) :-
	( atom(Term) ->
	    Goal =.. [Term|AddArgs]
	;
	    Term =.. List,
	    append(List, AddArgs, NewList),
	    Goal =.. NewList
	),
	call(Goal, Module).

