/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.EclipseConnectionImpl;
import com.parctechnologies.eclipse.QueueListener;
import java.io.IOException;
import java.io.OutputStream;

public class ToEclipseQueue
extends OutputStream {
    private String name;
    private int id;
    private EclipseConnectionImpl eclipse;
    private QueueListener listener = null;
    private boolean isClosed = false;
    private boolean systemQueue = false;

    ToEclipseQueue(int n, String string, EclipseConnectionImpl eclipseConnectionImpl) {
        this.eclipse = eclipseConnectionImpl;
        this.id = n;
        this.name = string;
    }

    public void close() throws IOException {
        this.testClosed();
        this.close_cleanup();
        this.eclipse.closeToEclipseStreamEclipseSide(this.id);
        this.eclipse.closeToEclipseStreamJavaSide(this.id);
    }

    void close_cleanup() {
        try {
            this.removeListener();
        }
        catch (IOException iOException) {
            System.err.println("Error: removal of listener threw an IOException.");
            System.err.flush();
        }
        this.isClosed = true;
    }

    public void flush() throws IOException {
        this.testClosed();
        this.eclipse.flushStream(this.id);
    }

    int getID() {
        return this.id;
    }

    boolean isSystemQueue() {
        return this.systemQueue;
    }

    void notifyRequest() {
        if (this.listener != null) {
            this.listener.dataRequest(this);
        }
    }

    public void removeListener() throws IOException {
        this.testClosed();
        this.listener = null;
    }

    public void setListener(QueueListener queueListener) throws IOException {
        this.testClosed();
        this.listener = queueListener;
    }

    void setSystemQueue(boolean bl) {
        this.systemQueue = bl;
    }

    private void testClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("Operation not possible: stream closed.");
        }
    }

    public void write(int n) throws IOException {
        this.testClosed();
        this.eclipse.writeByteToStream(this.id, (byte)n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.testClosed();
        this.eclipse.writeToStream(this.id, byArray, n, n2);
    }
}

