/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.Platform_i386_linux;
import com.parctechnologies.eclipse.Platform_i386_nt;
import com.parctechnologies.eclipse.Platform_sparc_sunos5;
import java.io.File;

abstract class Platform {
    private static Platform single = null;

    Platform() {
    }

    private static Platform findPlatform() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.arch");
        if ((string.equals("Windows NT") || string.equals("Windows 98") || string.equals("Windows 95") || string.equals("Windows 2000") || string.startsWith("Windows")) && string2.equals("x86")) {
            return new Platform_i386_nt();
        }
        if (string.equals("Linux") && (string2.equals("i386") || string2.equals("x86"))) {
            return new Platform_i386_linux();
        }
        if ((string.equals("SunOS") || string.equals("Solaris")) && string2.equals("sparc")) {
            return new Platform_sparc_sunos5();
        }
        return null;
    }

    abstract String getEclipsePlatformName();

    abstract File getExecutableSubdirectory(File var1);

    public static Platform getInstance() {
        if (single == null) {
            single = Platform.findPlatform();
        }
        return single;
    }

    File getLibrarySubdirectory(File file) {
        return new File(new File(file, "lib"), this.getEclipsePlatformName());
    }

    abstract void loadEclipseSharedLibrary(File var1) throws UnsatisfiedLinkError;

    public abstract boolean supportsEmbeddedEclipse();

    public abstract boolean supportsOutOfProcessEclipse();
}

