/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.EXDRInputStream;
import com.parctechnologies.eclipse.EXDROutputStream;
import com.parctechnologies.eclipse.EclipseConnection;
import com.parctechnologies.eclipse.EclipseException;
import com.parctechnologies.eclipse.EclipseTerminatedException;
import com.parctechnologies.eclipse.Fail;
import com.parctechnologies.eclipse.FromEclipseQueue;
import com.parctechnologies.eclipse.Throw;
import com.parctechnologies.eclipse.ToEclipseQueue;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public abstract class EclipseConnectionImpl
implements EclipseConnection {
    boolean terminated = false;
    private Map fromEclipseQueueRegister = new HashMap();
    private Map toEclipseQueueRegister = new HashMap();
    EXDROutputStream toEclipse;
    EXDRInputStream fromEclipse;
    private Atom _peerName;

    abstract int availableOnStream(int var1) throws IOException;

    private void closeAllFromEclipseQueues(boolean bl) throws IOException {
        LinkedList linkedList = new LinkedList(this.fromEclipseQueueRegister.values());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            FromEclipseQueue fromEclipseQueue = (FromEclipseQueue)iterator.next();
            if (fromEclipseQueue.isSystemQueue()) continue;
            fromEclipseQueue.close_cleanup();
            this.closeFromEclipseStreamJavaSide(fromEclipseQueue.getID());
            if (!bl) continue;
            this.closeFromEclipseStreamEclipseSide(fromEclipseQueue.getID());
        }
    }

    void closeAllQueues(boolean bl) throws IOException {
        this.closeAllFromEclipseQueues(bl);
        this.closeAllToEclipseQueues(bl);
    }

    private void closeAllToEclipseQueues(boolean bl) throws IOException {
        LinkedList linkedList = new LinkedList(this.toEclipseQueueRegister.values());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ToEclipseQueue toEclipseQueue = (ToEclipseQueue)iterator.next();
            if (toEclipseQueue.isSystemQueue()) continue;
            this.closeToEclipseStreamJavaSide(toEclipseQueue.getID());
            if (!bl) continue;
            this.closeToEclipseStreamEclipseSide(toEclipseQueue.getID());
        }
    }

    void closeFromEclipseStreamEclipseSide(int n) throws IOException {
    }

    void closeFromEclipseStreamJavaSide(int n) throws IOException {
        FromEclipseQueue fromEclipseQueue = this.lookupFromEclipseQueue(n);
        this.unregisterFromEclipseQueue(n);
    }

    void closeToEclipseStreamEclipseSide(int n) throws IOException {
    }

    void closeToEclipseStreamJavaSide(int n) throws IOException {
        ToEclipseQueue toEclipseQueue = this.lookupToEclipseQueue(n);
        this.unregisterToEclipseQueue(n);
    }

    public synchronized void compile(File file) throws EclipseException, IOException {
        this.rpc(new CompoundTermImpl("compile", this.getPath(file)));
    }

    FromEclipseQueue createFromEclipseQueue(String string) throws IOException {
        int n = this.getStreamNumber(string);
        FromEclipseQueue fromEclipseQueue = new FromEclipseQueue(n, string, this);
        this.registerFromEclipseQueue(n, fromEclipseQueue);
        return fromEclipseQueue;
    }

    ToEclipseQueue createToEclipseQueue(String string) throws IOException {
        int n = this.getStreamNumber(string);
        ToEclipseQueue toEclipseQueue = new ToEclipseQueue(n, string, this);
        this.registerToEclipseQueue(n, toEclipseQueue);
        return toEclipseQueue;
    }

    private CompoundTerm executeRpc(Object object) throws EclipseException, IOException {
        this.sendGoal(object);
        this.waitForEclipse(false);
        CompoundTerm compoundTerm = (CompoundTerm)this.receiveGoal();
        if (compoundTerm.functor().equals("fail") && compoundTerm.arity() == 0) {
            throw new Fail(object);
        }
        if (compoundTerm.functor().equals("throw") && compoundTerm.arity() == 0) {
            throw new Throw(object);
        }
        return compoundTerm;
    }

    abstract void flushStream(int var1) throws IOException;

    public synchronized FromEclipseQueue getFromEclipseQueue(String string) throws EclipseException, IOException {
        FromEclipseQueue fromEclipseQueue;
        this.testTerminated();
        int n = this.getStreamNumber(string);
        if (n >= 0 && (fromEclipseQueue = this.lookupFromEclipseQueue(n)) != null) {
            return fromEclipseQueue;
        }
        try {
            this.rpc("current_stream", new Atom(string));
            throw new EclipseException("Cannot create FromEclipseQueue: stream name in use.");
        }
        catch (Fail fail) {
            this.setupFromEclipseQueue(string);
            return this.createFromEclipseQueue(string);
        }
    }

    abstract ControlSignal getNextControlSignal(boolean var1, boolean var2) throws IOException;

    public String getPath(File file) throws EclipseException, IOException {
        CompoundTermImpl compoundTermImpl = new CompoundTermImpl("os_file_name", null, file.getAbsolutePath());
        return (String)this.rpc(compoundTermImpl).arg(1);
    }

    public Atom getPeerName() {
        return this._peerName;
    }

    int getStreamNumber(String string) throws IOException {
        try {
            this.rpc("current_stream", new Atom(string));
            CompoundTerm compoundTerm = this.rpc("get_stream_info", new Atom(string), new Atom("physical_stream"), null);
            Integer n = (Integer)compoundTerm.arg(3);
            return n;
        }
        catch (EclipseException eclipseException) {
            return -1;
        }
    }

    public synchronized ToEclipseQueue getToEclipseQueue(String string) throws EclipseException, IOException {
        ToEclipseQueue toEclipseQueue;
        this.testTerminated();
        int n = this.getStreamNumber(string);
        if (n >= 0 && (toEclipseQueue = this.lookupToEclipseQueue(n)) != null) {
            return toEclipseQueue;
        }
        try {
            this.rpc("current_stream", new Atom(string));
            throw new EclipseException("Cannot create ToEclipseQueue: stream name in use.");
        }
        catch (Fail fail) {
            this.setupToEclipseQueue(string);
            return this.createToEclipseQueue(string);
        }
    }

    FromEclipseQueue lookupFromEclipseQueue(int n) {
        return (FromEclipseQueue)this.fromEclipseQueueRegister.get(new Integer(n));
    }

    ToEclipseQueue lookupToEclipseQueue(int n) {
        return (ToEclipseQueue)this.toEclipseQueueRegister.get(new Integer(n));
    }

    abstract int readByteFromStream(int var1) throws IOException;

    abstract int readFromStream(int var1, int var2, int var3, byte[] var4) throws IOException;

    abstract Object receiveGoal() throws IOException;

    void registerFromEclipseQueue(int n, FromEclipseQueue fromEclipseQueue) throws EclipseTerminatedException {
        this.fromEclipseQueueRegister.put(new Integer(n), fromEclipseQueue);
    }

    void registerToEclipseQueue(int n, ToEclipseQueue toEclipseQueue) throws EclipseTerminatedException {
        this.toEclipseQueueRegister.put(new Integer(n), toEclipseQueue);
    }

    void respondCloseQueue(Integer n) throws IOException {
        FromEclipseQueue fromEclipseQueue = null;
        ToEclipseQueue toEclipseQueue = null;
        toEclipseQueue = this.lookupToEclipseQueue(n);
        if (toEclipseQueue != null) {
            toEclipseQueue.close_cleanup();
            this.closeToEclipseStreamJavaSide(n);
            return;
        }
        fromEclipseQueue = this.lookupFromEclipseQueue(n);
        if (fromEclipseQueue != null) {
            fromEclipseQueue.close_cleanup();
            this.closeFromEclipseStreamJavaSide(n);
            return;
        }
        System.err.println("Cannot close " + n + ": not the " + "stream number of a registered ECLiPSe queue.");
    }

    void respondOpenQueue(Atom atom, Integer n, Atom atom2) throws IOException {
        if (atom2.functor().equals("fromec")) {
            this.createFromEclipseQueue(atom.functor());
        }
        if (atom2.functor().equals("toec")) {
            this.createToEclipseQueue(atom.functor());
        }
    }

    void respondWaitIO(Integer n) throws IOException {
        ToEclipseQueue toEclipseQueue = this.lookupToEclipseQueue(n);
        if (toEclipseQueue == null) {
            System.err.println("ECLiPSe yielded after reading empty stream " + n + " which is not registered as a ToEclipseQueue.");
        } else {
            toEclipseQueue.notifyRequest();
        }
    }

    void respondYield() throws IOException {
    }

    public synchronized CompoundTerm rpc(CompoundTerm compoundTerm) throws EclipseException, IOException {
        this.testTerminated();
        return this.executeRpc(compoundTerm);
    }

    public synchronized CompoundTerm rpc(String string) throws EclipseException, IOException {
        this.testTerminated();
        return this.executeRpc(string);
    }

    public CompoundTerm rpc(String string, Object object) throws EclipseException, IOException {
        return this.rpc(new CompoundTermImpl(string, object));
    }

    public CompoundTerm rpc(String string, Object object, Object object2) throws EclipseException, IOException {
        return this.rpc(new CompoundTermImpl(string, object, object2));
    }

    public CompoundTerm rpc(String string, Object object, Object object2, Object object3) throws EclipseException, IOException {
        return this.rpc(new CompoundTermImpl(string, object, object2, object3));
    }

    public CompoundTerm rpc(String string, Object object, Object object2, Object object3, Object object4) throws EclipseException, IOException {
        return this.rpc(new CompoundTermImpl(string, object, object2, object3, object4));
    }

    public CompoundTerm rpc(String string, Object object, Object object2, Object object3, Object object4, Object object5) throws EclipseException, IOException {
        return this.rpc(new CompoundTermImpl(string, object, object2, object3, object4, object5));
    }

    public CompoundTerm rpc(String string, Object[] objectArray) throws EclipseException, IOException {
        return this.rpc(new CompoundTermImpl(string, objectArray));
    }

    public CompoundTerm rpc(Object[] objectArray) throws EclipseException, IOException {
        return this.rpc(new CompoundTermImpl(objectArray));
    }

    abstract void sendGoal(Object var1) throws IOException;

    void setPeerName(Atom atom) {
        this._peerName = atom;
    }

    abstract void setupFromEclipseQueue(String var1) throws EclipseException, IOException;

    abstract void setupToEclipseQueue(String var1) throws EclipseException, IOException;

    void testTerminated() throws EclipseTerminatedException {
        if (this.terminated) {
            throw new EclipseTerminatedException();
        }
    }

    void unregisterFromEclipseQueue(int n) {
        this.fromEclipseQueueRegister.remove(new Integer(n));
    }

    void unregisterToEclipseQueue(int n) {
        this.toEclipseQueueRegister.remove(new Integer(n));
    }

    void waitForEclipse(boolean bl) throws IOException {
        ControlSignal controlSignal;
        boolean bl2 = true;
        do {
            if ((controlSignal = this.getNextControlSignal(bl2, bl)) == null) {
                throw new IOException("Unrecognised ECLiPSe control signal.");
            }
            bl2 = false;
            controlSignal.respond();
        } while (!(controlSignal instanceof YieldSignal));
    }

    abstract void writeByteToStream(int var1, byte var2) throws IOException;

    abstract int writeToStream(int var1, byte[] var2, int var3, int var4) throws IOException;

    abstract class ControlSignal {
        ControlSignal() {
        }

        abstract void respond() throws IOException;
    }

    class YieldSignal
    extends ControlSignal {
        YieldSignal() {
        }

        void respond() throws IOException {
            EclipseConnectionImpl.this.respondYield();
        }
    }

    class WaitIOSignal
    extends ControlSignal {
        private Integer streamID;

        WaitIOSignal(Integer n) {
            this.streamID = n;
        }

        void respond() throws IOException {
            EclipseConnectionImpl.this.respondWaitIO(this.streamID);
        }
    }

    class OpenQueueSignal
    extends ControlSignal {
        private Atom nameAtom;
        private Integer streamID;
        private Atom direction;

        OpenQueueSignal(Atom atom, Integer n, Atom atom2) {
            this.nameAtom = atom;
            this.streamID = n;
            this.direction = atom2;
        }

        void respond() throws IOException {
            EclipseConnectionImpl.this.respondOpenQueue(this.nameAtom, this.streamID, this.direction);
        }
    }
}

