/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTermImpl;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;

public class EXDRInputStream
extends DataInputStream {
    public EXDRInputStream(InputStream inputStream) {
        super(inputStream);
    }

    private String readString() throws IOException {
        int n = this.readInt();
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return new String(byArray);
    }

    private Object readSubTerm() throws IOException {
        byte by = this.readByte();
        switch (by) {
            case 73: {
                return new Integer(this.readInt());
            }
            case 74: {
                return new Long(this.readLong());
            }
            case 68: {
                return new Double(this.readDouble());
            }
            case 95: {
                return null;
            }
            case 83: {
                return this.readString();
            }
            case 70: {
                int n = this.readInt();
                if (n == 0) {
                    return new Atom((String)this.readSubTerm());
                }
                Object[] objectArray = new Object[n + 1];
                int n2 = 0;
                while (n2 < n + 1) {
                    objectArray[n2] = this.readSubTerm();
                    ++n2;
                }
                return new CompoundTermImpl(objectArray);
            }
            case 91: {
                LinkedList<Object> linkedList = new LinkedList<Object>();
                linkedList.add(this.readSubTerm());
                while (true) {
                    if ((by = this.readByte()) == 93) {
                        return linkedList;
                    }
                    if (by != 91) break;
                    linkedList.add(this.readSubTerm());
                }
                throw new IOException("EXDR protocol error: unexpected list separator " + by);
            }
            case 93: {
                return Collections.EMPTY_LIST;
            }
        }
        throw new IOException("EXDR protocol error: unrecognized EXDR code = " + by);
    }

    public synchronized Object readTerm() throws IOException {
        byte by = this.readByte();
        byte by2 = this.readByte();
        if (by == 86 && by2 == 1) {
            return this.readSubTerm();
        }
        throw new IOException("EXDR protocol error: bad version " + by + " " + by2);
    }
}

