/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.visualisation.DebuggingSupport;
import com.parctechnologies.eclipse.visualisation.TextPanel;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.ViewletAction;
import com.parctechnologies.eclipse.visualisation.viewers.BlankViewletPanel;
import com.parctechnologies.eclipse.visualisation.viewers.HoldActionViewlet;
import com.parctechnologies.eclipse.visualisation.viewers.SymbolDecorator;
import com.parctechnologies.eclipse.visualisation.viewers.TextViewletFitCommand;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;

public class TextViewlet
extends HoldActionViewlet {
    private TextPanel textPanel;
    private String text = "";
    private CompoundTerm preBuildGoal;
    private CompoundTerm preUpdateGoal;

    public CompoundTerm collectPreBuildGoal() {
        if (this.preBuildGoal == null) {
            this.preBuildGoal = this.termToStringGoal(this.elementReference);
        }
        return this.preBuildGoal;
    }

    public CompoundTerm collectPreUpdateGoal(UpdateEvent updateEvent) {
        if (this.preUpdateGoal == null) {
            this.preUpdateGoal = this.termToStringGoal(this.elementReference);
        }
        return this.preUpdateGoal;
    }

    public void fitToText() {
        new TextViewletFitCommand(this).issue();
    }

    public void fitToTextPrivate() {
        this.textPanel.fitToText();
        ((JComponent)this.getComponent().getParent()).revalidate();
    }

    public Component getComponent() {
        if (this.component == null) {
            this.initialiseComponent();
        }
        return super.getComponent();
    }

    public String getDescription() {
        return "Text Viewlet";
    }

    public String getText() {
        return this.text;
    }

    private void initialiseComponent() {
        BlankViewletPanel blankViewletPanel = new BlankViewletPanel(this);
        this.textPanel = new TextPanel(this.getPropertyChangeSupport(), this.getText());
        SymbolDecorator symbolDecorator = new SymbolDecorator(this, this.textPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        blankViewletPanel.add((Component)symbolDecorator, gridBagConstraints);
        class Com_parctechnologies_eclipse_visualisation_viewers_TextViewlet$1 {
            /* synthetic */ Com_parctechnologies_eclipse_visualisation_viewers_TextViewlet$1() {
            }
        }
        this.actions.add(new FitToTextAction());
        this.component = blankViewletPanel;
        DebuggingSupport.logMessage(this, "component " + this.component.hashCode() + " initialised with textPanel " + this.textPanel.hashCode());
    }

    private void setText(String string) {
        String string2 = this.text;
        this.text = string;
        this.propertyChangeSupport.firePropertyChange("text", string2, string);
    }

    public void startBuild(CompoundTerm compoundTerm) {
        super.startBuild(compoundTerm);
        this.setText(this.termToStringGoalResult(compoundTerm));
    }

    public void startUpdate(UpdateEvent updateEvent, CompoundTerm compoundTerm) {
        super.startUpdate(updateEvent, compoundTerm);
        this.setText(this.termToStringGoalResult(compoundTerm));
    }

    private CompoundTerm termToStringGoal(Object object) {
        return new CompoundTermImpl(":", (Object)new Atom("vc_support"), (Object)new CompoundTermImpl("viewable_element_to_string", object, null));
    }

    private String termToStringGoalResult(Object object) {
        CompoundTermImpl compoundTermImpl = (CompoundTermImpl)object;
        return (String)compoundTermImpl.argCT(2).arg(2);
    }

    private class FitToTextAction
    extends ViewletAction {
        private FitToTextAction() {
            super("Fit to text");
            this.putValue("Name", "Fit to text");
            this.putValue("LongDescription", "Change the size of the text panel to fit the current text");
            this.putValue("ShortDescription", "Fit size to current text");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TextViewlet.this.fitToText();
        }

        public ViewletAction createCompoundAction(Collection collection) {
            return new CompoundFitToTextAction(collection);
        }

        private class CompoundFitToTextAction
        extends FitToTextAction {
            private Collection viewlets;

            CompoundFitToTextAction(Collection collection) {
                this.viewlets = collection;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Iterator iterator = this.viewlets.iterator();
                while (iterator.hasNext()) {
                    TextViewlet textViewlet = (TextViewlet)iterator.next();
                    textViewlet.fitToText();
                }
            }
        }
    }
}

