/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import com.parctechnologies.eclipse.visualisation.Viewlet;
import com.parctechnologies.eclipse.visualisation.Zoomable;
import com.parctechnologies.eclipse.visualisation.ZoomableJPanel;
import com.parctechnologies.eclipse.visualisation.viewers.HoldIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Polygon;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

public class SymbolDecorator
extends ZoomableJPanel {
    private HoldSymbolPanel holdSymbolPanel;
    private DirectionSymbolPanel directionSymbolPanel;
    private Zoomable decoratee;
    private Viewlet viewlet;

    public SymbolDecorator(Viewlet viewlet, Zoomable zoomable) {
        super(new GridBagLayout());
        this.viewlet = viewlet;
        this.decoratee = zoomable;
        this.setOpaque(false);
        this.initialiseSymbols();
        this.addChildComponents();
    }

    private void addChildComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.weightx = 1.0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        this.add((Component)this.directionSymbolPanel, gridBagConstraints);
        this.add((Component)this.holdSymbolPanel, gridBagConstraints2);
        this.add((Component)((Object)this.decoratee), gridBagConstraints3);
    }

    public Dimension getNormalSize() {
        int n = Math.max(this.decoratee.getNormalSize().width, this.holdSymbolPanel.getNormalSize().width + this.directionSymbolPanel.getNormalSize().width);
        int n2 = this.decoratee.getNormalSize().height + this.holdSymbolPanel.getNormalSize().height + this.directionSymbolPanel.getNormalSize().height;
        return new Dimension(n, n2);
    }

    private void initialiseSymbols() {
        this.holdSymbolPanel = new HoldSymbolPanel(20, 20, this.viewlet.getHoldsOnUpdates());
        this.viewlet.getPropertyChangeSupport().addPropertyChangeListener("holdsOnUpdates", this.holdSymbolPanel);
        this.directionSymbolPanel = new DirectionSymbolPanel(40, 20);
        this.viewlet.getPropertyChangeSupport().addPropertyChangeListener("updating", this.directionSymbolPanel);
    }

    public void zoomToLevel(float f) {
        this.setZoomLevel(f);
        this.zoomChildrenToLevel(f);
        this.invalidate();
    }

    private abstract class SymbolPanel
    extends ZoomableJPanel {
        private int currentState;
        private boolean shapesInitialised = false;

        protected SymbolPanel(int n, int n2) {
            this.setPreferredSize(new Dimension(n, n2));
            this.setNormalSize(this.getPreferredSize());
        }

        int getCurrentState() {
            return this.currentState;
        }

        protected void initialiseShapes(double d, double d2) {
            this.shapesInitialised = true;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (!this.shapesInitialised) {
                this.initialiseShapes(this.getSize().width, this.getSize().height);
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            this.initialiseShapes(n3, n4);
            super.setBounds(n, n2, n3, n4);
        }

        void setState(int n) {
            if (n != this.currentState) {
                this.currentState = n;
                this.repaint();
            }
        }
    }

    private class DirectionSymbolPanel
    extends SymbolPanel
    implements PropertyChangeListener {
        private Polygon forwardTriangle1;
        private Polygon forwardTriangle2;
        private Polygon backTriangle1;
        private Polygon backTriangle2;
        private Color forwardColor = new Color(20, 200, 20);
        private Color backColor = new Color(200, 20, 20);
        static final int NO_STATE = 0;
        static final int FORWARD_STATE = 1;
        static final int BACK_STATE = 2;

        DirectionSymbolPanel(int n, int n2) {
            super(n, n2);
            this.setState(0);
            this.setOpaque(false);
        }

        protected void initialiseShapes(double d, double d2) {
            super.initialiseShapes(d, d2);
            double d3 = d * 0.4;
            double d4 = d2 * 0.8;
            double d5 = d * 0.05;
            double d6 = d2 * 0.1;
            int n = (int)d5;
            int n2 = n + (int)d3;
            int n3 = n2 + (int)d5;
            int n4 = n3 + (int)d3;
            int n5 = (int)d6;
            int n6 = n5 + (int)(d4 / 2.0);
            int n7 = n6 + (int)(d4 / 2.0);
            this.forwardTriangle1 = new Polygon(new int[]{n, n2, n}, new int[]{n5, n6, n7}, 3);
            this.forwardTriangle2 = new Polygon(new int[]{n3, n4, n3}, new int[]{n5, n6, n7}, 3);
            this.backTriangle1 = new Polygon(new int[]{n2, n, n2}, new int[]{n5, n6, n7}, 3);
            this.backTriangle2 = new Polygon(new int[]{n4, n3, n4}, new int[]{n5, n6, n7}, 3);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.getCurrentState() == 1) {
                graphics.setColor(this.forwardColor);
                graphics.fillPolygon(this.forwardTriangle1);
                graphics.fillPolygon(this.forwardTriangle2);
                graphics.setColor(this.getForeground());
                graphics.drawPolygon(this.forwardTriangle1);
                graphics.drawPolygon(this.forwardTriangle2);
                return;
            }
            if (this.getCurrentState() == 2) {
                graphics.setColor(this.backColor);
                graphics.fillPolygon(this.backTriangle1);
                graphics.fillPolygon(this.backTriangle2);
                graphics.setColor(this.getForeground());
                graphics.drawPolygon(this.backTriangle1);
                graphics.drawPolygon(this.backTriangle2);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getNewValue().equals("updatingForward")) {
                this.setState(1);
                return;
            }
            if (propertyChangeEvent.getNewValue().equals("updatingBack")) {
                this.setState(2);
                return;
            }
            if (propertyChangeEvent.getNewValue().equals("no")) {
                this.setState(0);
                return;
            }
        }
    }

    private class HoldSymbolPanel
    extends SymbolPanel
    implements PropertyChangeListener {
        static final int HOLD_ON_STATE = 0;
        static final int HOLD_OFF_STATE = 1;
        private Icon holdIcon;

        HoldSymbolPanel(int n, int n2, boolean bl) {
            super(n, n2);
            if (bl) {
                this.setState(0);
            } else {
                this.setState(1);
            }
            this.setOpaque(false);
        }

        protected void initialiseShapes(double d, double d2) {
            super.initialiseShapes(d, d2);
            this.holdIcon = new HoldIcon((int)d, (int)d2);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.getCurrentState() == 0) {
                this.holdIcon.paintIcon(this, graphics, 0, 0);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                this.setState(0);
                return;
            }
            if (propertyChangeEvent.getNewValue().equals(Boolean.FALSE)) {
                this.setState(1);
            }
        }
    }
}

