/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import com.parctechnologies.eclipse.visualisation.ViewletAction;
import com.parctechnologies.eclipse.visualisation.ViewletImpl;
import com.parctechnologies.eclipse.visualisation.viewers.HoldIcon;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;

public class HoldActionViewlet
extends ViewletImpl {
    public HoldActionViewlet() {
        this.actions.add(new ToggleHoldAction());
    }

    private class ToggleHoldAction
    extends ViewletAction {
        ToggleHoldAction() {
            super("Hold on updates");
            this.putValue("Name", "Hold on updates");
            this.putValue("LongDescription", "Change whether control is held by the visualisation client during element updates");
            this.putValue("ShortDescription", "Change whether control is held on updates");
            this.putValue("SmallIcon", new HoldIcon(20, 20));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HoldActionViewlet.this.setHoldsOnUpdates(HoldActionViewlet.this.getHoldsOnUpdates() ^ true);
        }

        public ViewletAction createCompoundAction(Collection collection) {
            boolean bl = true;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ViewletImpl viewletImpl = (ViewletImpl)iterator.next();
                if (viewletImpl.getHoldsOnUpdates()) continue;
                bl = false;
                break;
            }
            return new CompoundToggleHoldAction(bl ^ true, collection);
        }
    }

    private class CompoundToggleHoldAction
    extends ToggleHoldAction {
        private boolean newValue;
        private Collection viewlets;

        CompoundToggleHoldAction(boolean bl, Collection collection) {
            this.newValue = bl;
            this.viewlets = collection;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Iterator iterator = this.viewlets.iterator();
            while (iterator.hasNext()) {
                ViewletImpl viewletImpl = (ViewletImpl)iterator.next();
                viewletImpl.setHoldsOnUpdates(this.newValue);
            }
        }
    }
}

