/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.visualisation.DebuggingSupport;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.ViewletAction;
import com.parctechnologies.eclipse.visualisation.viewers.BlankViewletPanel;
import com.parctechnologies.eclipse.visualisation.viewers.BoundsPanel;
import com.parctechnologies.eclipse.visualisation.viewers.BoundsViewletAlignCommand;
import com.parctechnologies.eclipse.visualisation.viewers.BoundsViewletToggleRangeCommand;
import com.parctechnologies.eclipse.visualisation.viewers.HoldActionViewlet;
import com.parctechnologies.eclipse.visualisation.viewers.SymbolDecorator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class BoundsViewlet
extends HoldActionViewlet {
    private BoundsPanel boundsPanel;
    private Double lowerBound;
    private Double upperBound;
    private Double initialLowerBound;
    private Double initialUpperBound;
    private Double alignLowerBound;
    private Double alignUpperBound;
    private CompoundTerm preBuildGoal;
    private CompoundTerm preUpdateGoal;
    private boolean horizontalBar = true;

    void align(Double d, Double d2) {
        new BoundsViewletAlignCommand(this, d, d2).issue();
    }

    void alignPrivate(Double d, Double d2) {
        this.setAlignLowerBound(d);
        this.setAlignUpperBound(d2);
        DebuggingSupport.logMessage(this, "Re aligned to " + d + ", " + d2);
    }

    public CompoundTerm collectPreBuildGoal() {
        if (this.preBuildGoal == null) {
            this.preBuildGoal = this.termToBoundsGoal(this.elementReference);
        }
        return this.preBuildGoal;
    }

    public CompoundTerm collectPreUpdateGoal(UpdateEvent updateEvent) {
        if (this.preUpdateGoal == null) {
            this.preUpdateGoal = this.termToBoundsGoal(this.elementReference);
        }
        return this.preUpdateGoal;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.initialiseComponent();
        }
        return super.getComponent();
    }

    public String getDescription() {
        return "Bounds Viewlet";
    }

    public boolean getHorizontalBar() {
        return this.horizontalBar;
    }

    private void initialiseComponent() {
        BlankViewletPanel blankViewletPanel = new BlankViewletPanel(this);
        this.boundsPanel = new BoundsPanel(this, this.initialLowerBound, this.lowerBound, this.upperBound, this.initialUpperBound, this.alignLowerBound, this.alignUpperBound);
        SymbolDecorator symbolDecorator = new SymbolDecorator(this, this.boundsPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        blankViewletPanel.add((Component)symbolDecorator, gridBagConstraints);
        this.component = blankViewletPanel;
        DebuggingSupport.logMessage(this, "component " + this.component.hashCode() + " initialised with boundsPanel " + this.boundsPanel.hashCode());
        class Com_parctechnologies_eclipse_visualisation_viewers_BoundsViewlet$1 {
            /* synthetic */ Com_parctechnologies_eclipse_visualisation_viewers_BoundsViewlet$1() {
            }
        }
        this.actions.add(new ViewBoundsInDetailAction());
        this.actions.add(new AlignAction());
        this.actions.add(new ToggleHorizontalVerticalAction());
    }

    private void setAlignLowerBound(Double d) {
        Double d2 = this.alignLowerBound;
        this.alignLowerBound = d;
        this.getPropertyChangeSupport().firePropertyChange("alignLowerBound", d2, d);
    }

    private void setAlignUpperBound(Double d) {
        Double d2 = this.alignUpperBound;
        this.alignUpperBound = d;
        this.getPropertyChangeSupport().firePropertyChange("alignUpperBound", d2, d);
    }

    private void setBoundsFromGoalResult(CompoundTerm compoundTerm) {
        this.setLowerBound((Double)compoundTerm.arg(2));
        this.setUpperBound((Double)compoundTerm.arg(3));
    }

    public void setHorizontalBar(boolean bl) {
        new BoundsViewletToggleRangeCommand(this, bl).issue();
    }

    void setHorizontalBarPrivate(boolean bl) {
        boolean bl2 = this.horizontalBar;
        this.horizontalBar = bl;
        this.getPropertyChangeSupport().firePropertyChange("horizontalBar", bl2, bl);
        ((JComponent)this.getComponent().getParent()).revalidate();
    }

    private void setInitialBoundsFromGoalResult(CompoundTerm compoundTerm) {
        this.setInitialLowerBound((Double)compoundTerm.arg(2));
        this.setInitialUpperBound((Double)compoundTerm.arg(3));
    }

    private void setInitialLowerBound(Double d) {
        this.initialLowerBound = d;
        this.getPropertyChangeSupport().firePropertyChange("initialLowerBound", null, d);
    }

    private void setInitialUpperBound(Double d) {
        this.initialUpperBound = d;
        this.getPropertyChangeSupport().firePropertyChange("initialUpperBound", null, d);
    }

    private void setLowerBound(Double d) {
        Double d2 = this.lowerBound;
        this.lowerBound = d;
        this.getPropertyChangeSupport().firePropertyChange("lowerBound", d2, d);
    }

    private void setUpperBound(Double d) {
        Double d2 = this.upperBound;
        this.upperBound = d;
        this.getPropertyChangeSupport().firePropertyChange("upperBound", d2, d);
    }

    public void startBuild(CompoundTerm compoundTerm) {
        super.startBuild(compoundTerm);
        this.setInitialBoundsFromGoalResult(compoundTerm);
        this.setBoundsFromGoalResult(compoundTerm);
        this.setAlignLowerBound(this.initialLowerBound);
        this.setAlignUpperBound(this.initialUpperBound);
    }

    public void startUpdate(UpdateEvent updateEvent, CompoundTerm compoundTerm) {
        super.startUpdate(updateEvent, compoundTerm);
        this.setBoundsFromGoalResult(compoundTerm);
    }

    private CompoundTerm termToBoundsGoal(Object object) {
        return new CompoundTermImpl("get_var_bounds", object, null, null);
    }

    private class ViewBoundsInDetailAction
    extends ViewletAction {
        private ViewBoundsInDetailAction() {
            super("View bounds in detail");
            this.putValue("Name", "View bounds in detail");
            this.putValue("LongDescription", "Pop up a dialog box to view the values of the initial and current numeric bounds");
            this.putValue("ShortDescription", "Dialog box to view the numeric bounds values");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showConfirmDialog(((JComponent)BoundsViewlet.this.getComponent()).getRootPane(), "Initial upper bound: " + BoundsViewlet.this.initialUpperBound + "\n\n" + "Current upper bound: " + BoundsViewlet.this.upperBound + "\n\n" + "Current lower bound: " + BoundsViewlet.this.lowerBound + "\n\n" + "Initial lower bound: " + BoundsViewlet.this.initialLowerBound, "Bounds data in detail", -1);
        }

        public ViewletAction createCompoundAction(Collection collection) {
            ViewBoundsInDetailAction viewBoundsInDetailAction = new ViewBoundsInDetailAction();
            viewBoundsInDetailAction.setEnabled(false);
            return viewBoundsInDetailAction;
        }
    }

    private class AlignAction
    extends ViewletAction {
        private Collection viewlets;

        private AlignAction() {
            super("Align bounds");
            this.putValue("Name", "Align bounds");
            this.putValue("LongDescription", "Re-align a selection of bounds viewlets so that their bounds are displayed on the same axes");
            this.putValue("ShortDescription", "Re-align so that bounds viewlets use the same axes");
            this.setEnabled(false);
        }

        private AlignAction(Collection collection) {
            this();
            this.viewlets = collection;
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BoundsViewlet boundsViewlet;
            Iterator iterator = this.viewlets.iterator();
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            while (iterator.hasNext()) {
                boundsViewlet = (BoundsViewlet)iterator.next();
                if (boundsViewlet.initialLowerBound < d) {
                    d = boundsViewlet.initialLowerBound;
                }
                if (!(boundsViewlet.initialUpperBound > d2)) continue;
                d2 = boundsViewlet.initialUpperBound;
            }
            iterator = this.viewlets.iterator();
            Double d3 = new Double(d);
            Double d4 = new Double(d2);
            while (iterator.hasNext()) {
                boundsViewlet = (BoundsViewlet)iterator.next();
                boundsViewlet.align(d3, d4);
            }
        }

        public ViewletAction createCompoundAction(Collection collection) {
            AlignAction alignAction = new AlignAction(collection);
            return alignAction;
        }
    }

    private class ToggleHorizontalVerticalAction
    extends ViewletAction {
        ToggleHorizontalVerticalAction() {
            super("Toggle horizontal/vertical range bar");
            this.putValue("Name", "Toggle horizontal/vertical range bar");
            this.putValue("LongDescription", "Change whether the range bar is displayed horizontally or vertically");
            this.putValue("ShortDescription", "Change whether the range bar is horizontal or vertical");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BoundsViewlet.this.setHorizontalBar(BoundsViewlet.this.getHorizontalBar() ^ true);
        }

        public ViewletAction createCompoundAction(Collection collection) {
            boolean bl = true;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                BoundsViewlet boundsViewlet = (BoundsViewlet)iterator.next();
                if (boundsViewlet.getHorizontalBar()) continue;
                bl = false;
                break;
            }
            return new CompoundToggleHorizontalVerticalAction(bl ^ true, collection);
        }
    }

    private class CompoundToggleHorizontalVerticalAction
    extends ToggleHorizontalVerticalAction {
        private boolean newValue;
        private Collection viewlets;

        CompoundToggleHorizontalVerticalAction(boolean bl, Collection collection) {
            this.newValue = bl;
            this.viewlets = collection;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Iterator iterator = this.viewlets.iterator();
            while (iterator.hasNext()) {
                BoundsViewlet boundsViewlet = (BoundsViewlet)iterator.next();
                boundsViewlet.setHorizontalBar(this.newValue);
            }
        }
    }
}

