/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import com.parctechnologies.eclipse.visualisation.ZoomableJPanel;
import com.parctechnologies.eclipse.visualisation.viewers.BoundsViewlet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class BoundsPanel
extends ZoomableJPanel
implements PropertyChangeListener {
    private static float initialHeightProportion = 0.8f;
    private static float alignWidthProportion = 0.8f;
    private static float currentHeightProportion = 0.4f;
    private static Color initialBarsColour = Color.lightGray;
    private static Color currentBoundsFillColour = new Color(100, 130, 100);
    private static Color currentBoundsBoxColour = Color.black;
    private Dimension lastSize;
    private BoundsViewlet viewlet;
    private Double initialLowerBound;
    private Double lowerBound;
    private Double upperBound;
    private Double initialUpperBound;
    private Double alignLowerBound;
    private Double alignUpperBound;
    private float initialTotalRange;
    private float alignTotalRange;
    private boolean horizontalBar = true;
    private boolean recalculateVerticalPixels;
    private boolean recalculateInitialBoundsPixels;
    private boolean recalculateCurrentBoundsPixels;
    private boolean recalculateAlignBoundsPixels;
    private int currentTop;
    private int currentHeight;
    private int currentLeft;
    private int currentWidth;
    private int alignLeft;
    private int alignWidth;
    private float pixelsPerUnit;
    private int initialTop;
    private int initialBottom;
    private int initialLeft;
    private int initialRight;
    private int initialWidth;
    private int initialHeight;
    private int initialHalfWayUp;
    private int width;
    private int height;

    BoundsPanel(BoundsViewlet boundsViewlet, Double d, Double d2, Double d3, Double d4, Double d5, Double d6) {
        this.setPreferredSize(new Dimension(100, 30));
        this.setNormalSize(this.getPreferredSize());
        this.initialLowerBound = d;
        this.lowerBound = d2;
        this.upperBound = d3;
        this.initialUpperBound = d4;
        this.alignLowerBound = d5;
        this.alignUpperBound = d6;
        this.upperBound = d3;
        this.initialTotalRange = d4.floatValue() - d.floatValue();
        this.alignTotalRange = d6.floatValue() - d5.floatValue();
        this.viewlet = boundsViewlet;
        boundsViewlet.getPropertyChangeSupport().addPropertyChangeListener("lowerBound", this);
        boundsViewlet.getPropertyChangeSupport().addPropertyChangeListener("upperBound", this);
        boundsViewlet.getPropertyChangeSupport().addPropertyChangeListener("initialLowerBound", this);
        boundsViewlet.getPropertyChangeSupport().addPropertyChangeListener("initialUpperBound", this);
        boundsViewlet.getPropertyChangeSupport().addPropertyChangeListener("alignLowerBound", this);
        boundsViewlet.getPropertyChangeSupport().addPropertyChangeListener("alignUpperBound", this);
        boundsViewlet.getPropertyChangeSupport().addPropertyChangeListener("horizontalBar", this);
        this.setOpaque(false);
        this.recalculateVerticalPixels = true;
        this.recalculateAlignBoundsPixels = true;
        this.recalculateInitialBoundsPixels = true;
        this.recalculateCurrentBoundsPixels = true;
    }

    private void calculateAlignBoundsPixels() {
        this.width = this.horizontalBar ? this.getWidth() : this.getHeight();
        this.alignWidth = (int)((float)this.width * alignWidthProportion);
        this.alignLeft = (this.width - this.alignWidth) / 2;
        this.alignTotalRange = this.alignUpperBound.floatValue() - this.alignLowerBound.floatValue();
        this.pixelsPerUnit = (float)this.alignWidth / this.alignTotalRange;
        this.recalculateAlignBoundsPixels = false;
    }

    private void calculateCurrentBoundsPixels() {
        this.currentLeft = this.alignLeft + (int)((this.lowerBound.floatValue() - this.alignLowerBound.floatValue()) * this.pixelsPerUnit);
        this.currentWidth = (int)((this.upperBound.floatValue() - this.lowerBound.floatValue()) * this.pixelsPerUnit);
        this.recalculateCurrentBoundsPixels = false;
    }

    private void calculateInitialBoundsPixels() {
        this.initialWidth = (int)(this.initialTotalRange * this.pixelsPerUnit);
        this.initialLeft = this.alignLeft + (int)((this.initialLowerBound.floatValue() - this.alignLowerBound.floatValue()) * this.pixelsPerUnit);
        this.initialRight = this.initialWidth + this.initialLeft;
        this.recalculateInitialBoundsPixels = false;
    }

    private void calculateVerticalPixels() {
        this.height = this.horizontalBar ? this.getHeight() : this.getWidth();
        this.initialHeight = (int)((float)this.height * initialHeightProportion);
        this.initialTop = (this.height - this.initialHeight) / 2;
        this.initialBottom = this.initialHeight + this.initialTop;
        this.initialHalfWayUp = (this.initialTop + this.initialBottom) / 2;
        this.currentHeight = (int)((float)this.height * currentHeightProportion);
        this.currentTop = (this.height - this.currentHeight) / 2;
        this.recalculateVerticalPixels = false;
    }

    private void drawCurrentBounds(Graphics graphics) {
        graphics.setColor(currentBoundsFillColour);
        if (this.horizontalBar) {
            graphics.fillRect(this.currentLeft, this.currentTop, this.currentWidth, this.currentHeight);
        } else {
            graphics.fillRect(this.currentTop, this.width - (this.currentLeft + this.currentWidth), this.currentHeight, this.currentWidth);
        }
        graphics.setColor(currentBoundsBoxColour);
        if (this.horizontalBar) {
            graphics.drawRect(this.currentLeft, this.currentTop, this.currentWidth, this.currentHeight);
        } else {
            graphics.drawRect(this.currentTop, this.width - (this.currentLeft + this.currentWidth), this.currentHeight, this.currentWidth);
        }
    }

    private void drawInitialBounds(Graphics graphics) {
        graphics.setColor(initialBarsColour);
        if (this.horizontalBar) {
            graphics.drawLine(this.initialLeft, this.initialTop, this.initialLeft, this.initialBottom);
            graphics.drawLine(this.initialRight, this.initialTop, this.initialRight, this.initialBottom);
            graphics.drawLine(this.initialLeft, this.initialHalfWayUp, this.initialRight, this.initialHalfWayUp);
        } else {
            graphics.drawLine(this.initialTop, this.width - this.initialLeft, this.initialBottom, this.width - this.initialLeft);
            graphics.drawLine(this.initialTop, this.width - this.initialRight, this.initialBottom, this.width - this.initialRight);
            graphics.drawLine(this.initialHalfWayUp, this.width - this.initialLeft, this.initialHalfWayUp, this.width - this.initialRight);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.getSize().equals(this.lastSize)) {
            this.recalculateVerticalPixels = true;
            this.recalculateAlignBoundsPixels = true;
            this.recalculateInitialBoundsPixels = true;
            this.recalculateCurrentBoundsPixels = true;
        }
        if (this.recalculateVerticalPixels) {
            this.calculateVerticalPixels();
        }
        if (this.recalculateAlignBoundsPixels) {
            this.calculateAlignBoundsPixels();
        }
        if (this.recalculateInitialBoundsPixels) {
            this.calculateInitialBoundsPixels();
        }
        this.drawInitialBounds(graphics);
        if (this.recalculateCurrentBoundsPixels) {
            this.calculateCurrentBoundsPixels();
        }
        this.drawCurrentBounds(graphics);
        this.lastSize = this.getSize();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("upperBound")) {
            this.upperBound = (Double)propertyChangeEvent.getNewValue();
            this.recalculateCurrentBoundsPixels = true;
            this.repaint();
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("lowerBound")) {
            this.lowerBound = (Double)propertyChangeEvent.getNewValue();
            this.recalculateCurrentBoundsPixels = true;
            this.repaint();
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("initialUpperBound")) {
            this.initialUpperBound = (Double)propertyChangeEvent.getNewValue();
            this.recalculateInitialBoundsPixels = true;
            this.recalculateCurrentBoundsPixels = true;
            this.repaint();
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("initialLowerBound")) {
            this.initialLowerBound = (Double)propertyChangeEvent.getNewValue();
            this.recalculateInitialBoundsPixels = true;
            this.recalculateCurrentBoundsPixels = true;
            this.repaint();
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("alignUpperBound")) {
            this.alignUpperBound = (Double)propertyChangeEvent.getNewValue();
            this.recalculateAlignBoundsPixels = true;
            this.recalculateInitialBoundsPixels = true;
            this.recalculateCurrentBoundsPixels = true;
            this.repaint();
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("alignLowerBound")) {
            this.alignLowerBound = (Double)propertyChangeEvent.getNewValue();
            this.recalculateAlignBoundsPixels = true;
            this.recalculateInitialBoundsPixels = true;
            this.recalculateCurrentBoundsPixels = true;
            this.repaint();
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("horizontalBar")) {
            this.horizontalBar = (Boolean)propertyChangeEvent.getNewValue();
            Dimension dimension = this.getPreferredSize();
            Dimension dimension2 = this.getNormalSize();
            this.setNormalSize(new Dimension(dimension2.height, dimension2.width));
            this.setPreferredSize(new Dimension(dimension.height, dimension.width));
            this.recalculateVerticalPixels = true;
            this.recalculateAlignBoundsPixels = true;
            this.recalculateInitialBoundsPixels = true;
            this.recalculateCurrentBoundsPixels = true;
            this.invalidate();
            this.revalidate();
            this.repaint();
            return;
        }
    }

    public void zoomToLevel(float f) {
        super.zoomToLevel(f);
        this.recalculateVerticalPixels = true;
        this.recalculateAlignBoundsPixels = true;
        this.recalculateInitialBoundsPixels = true;
        this.recalculateCurrentBoundsPixels = true;
    }
}

