/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import com.parctechnologies.eclipse.visualisation.RootViewletComponent;
import com.parctechnologies.eclipse.visualisation.Viewlet;
import com.parctechnologies.eclipse.visualisation.ZoomableJPanel;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

class BlankViewletPanel
extends ZoomableJPanel
implements PropertyChangeListener,
RootViewletComponent {
    private Viewlet viewlet;
    private boolean selected;
    private Color selectedColour = new Color(160, 160, 200);
    private Color unselectedColour = Color.white;

    public BlankViewletPanel(Viewlet viewlet) {
        super(new GridBagLayout());
        this.viewlet = viewlet;
        this.setOpaque(true);
        this.setBackground(this.unselectedColour);
        this.setSelected(viewlet.getSelected());
        viewlet.getPropertyChangeSupport().addPropertyChangeListener("selected", this);
    }

    public Viewlet getViewlet() {
        return this.viewlet;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setSelected((Boolean)propertyChangeEvent.getNewValue());
    }

    private void setSelected(boolean bl) {
        if (this.selected != bl) {
            this.selected = bl;
            if (bl) {
                this.setBackground(this.selectedColour);
            } else {
                this.setBackground(this.unselectedColour);
            }
        }
    }

    public void zoomToLevel(float f) {
        this.setZoomLevel(f);
        this.zoomChildrenToLevel(f);
        this.invalidate();
    }
}

