/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.EclipseConnection;
import com.parctechnologies.eclipse.EclipseException;
import com.parctechnologies.eclipse.visualisation.BatchGoal;
import com.parctechnologies.eclipse.visualisation.VisClient;
import com.parctechnologies.eclipse.visualisation.VisException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Timer;

public class VisClientStateModel {
    public static final int SETTING_VIEWER_POLICY = 0;
    public static final int COLLECTING_PRE_EVENT_GOALS = 1;
    public static final int EXECUTING_PRE_EVENT_GOALS = 2;
    public static final int DISTRIBUTING_PRE_EVENT_GOAL_RESULTS = 3;
    public static final int EVENT_IS_HAPPENING = 4;
    public static final int EVENT_IS_FINISHED = 5;
    public static final int NO_CURRENT_EVENT = 6;
    public static final int EXECUTING_IN_EVENT_GOAL = 7;
    private boolean eclipseHasControl;
    private boolean autoResume = false;
    private boolean interrupt = false;
    private boolean terminate = false;
    private boolean recordScenario = true;
    private boolean allScenarioCommandsExecuted;
    private boolean viewerBuildingPolicySelected = false;
    private Atom visClientName;
    private InEventGoal inEventGoal = null;
    private VisClient visClient;
    private BoundedRangeModel delayModel;
    private int currentState;
    private EclipseConnection eclipse;
    private Action resumeAction;
    private Action interruptAction;
    private Action autoResumeAction;
    private AutoResumeTimer autoResumeTimer;
    private PropertyChangeSupport propertyChangeSupport;

    public VisClientStateModel(EclipseConnection eclipseConnection, Atom atom, VisClient visClient) {
        this.eclipse = eclipseConnection;
        this.visClientName = atom;
        this.visClient = visClient;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.setCurrentState(6);
        this.setEclipseHasControl(true);
        this.resumeAction = new ResumeAction();
        this.autoResumeAction = new AutoResumeAction();
        this.interruptAction = new InterruptAction();
        this.delayModel = new DefaultBoundedRangeModel(1000, 1, 0, 5000);
    }

    CompoundTerm executeInEventGoal(CompoundTerm compoundTerm) throws VisException {
        if (this.getCurrentState() == 4) {
            CompoundTerm compoundTerm2;
            BatchGoal batchGoal = new BatchGoal();
            batchGoal.add(compoundTerm);
            try {
                class Com_parctechnologies_eclipse_visualisation_VisClientStateModel$1 {
                    /* synthetic */ Com_parctechnologies_eclipse_visualisation_VisClientStateModel$1() {
                    }
                }
                this.inEventGoal = new InEventGoal(null, batchGoal);
                this.setCurrentState(7);
                compoundTerm2 = (CompoundTerm)this.inEventGoal.getResults().get(0);
            }
            finally {
                Object var5_4 = null;
                this.setCurrentState(4);
                this.inEventGoal = null;
            }
            return compoundTerm2;
        }
        throw new VisException("VisClient is not in a state where in-event goals can be posted");
    }

    public synchronized boolean getAutoResume() {
        return this.autoResume;
    }

    public synchronized int getCurrentState() {
        return this.currentState;
    }

    public BoundedRangeModel getDelayModel() {
        return this.delayModel;
    }

    public synchronized boolean getEclipseHasControl() {
        return this.eclipseHasControl;
    }

    public boolean getInterrupt() {
        return this.interrupt;
    }

    public Action getInterruptAction() {
        return this.interruptAction;
    }

    PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public synchronized boolean getRecordScenario() {
        return this.recordScenario;
    }

    public Action getResumeAction() {
        return this.resumeAction;
    }

    public synchronized boolean getTerminate() {
        return this.terminate;
    }

    public synchronized boolean getViewerBuildingPolicySelected() {
        return this.viewerBuildingPolicySelected;
    }

    public VisClient getVisClient() {
        return this.visClient;
    }

    public Atom getVisClientName() {
        return this.visClientName;
    }

    void resume() {
        this.getResumeAction().setEnabled(false);
        this.setCurrentState(5);
    }

    public synchronized void setAllScenarioCommandsExecuted(boolean bl) {
        this.allScenarioCommandsExecuted = bl;
        this.notifyAll();
    }

    public synchronized void setAutoResume(boolean bl) {
        if (this.autoResume != bl) {
            boolean bl2 = this.autoResume;
            this.autoResume = bl;
            this.propertyChangeSupport.firePropertyChange("autoResume", new Boolean(bl2), new Boolean(bl));
            if (!bl && this.autoResumeTimer != null && this.autoResumeTimer.isRunning()) {
                this.stopAutoResumeTimer();
            }
        }
    }

    synchronized void setCurrentState(int n) {
        if (this.currentState != n) {
            int n2 = this.currentState;
            this.currentState = n;
            this.propertyChangeSupport.firePropertyChange("currentVisClientState", new Integer(n2), new Integer(this.currentState));
            if (this.getAutoResume() && !this.getInterrupt() && n == 4) {
                this.startAutoResumeTimer();
            }
            if ((n == 5 || n == 7) && this.getAutoResume()) {
                this.stopAutoResumeTimer();
            }
        }
        this.notifyAll();
    }

    synchronized void setEclipseHasControl(boolean bl) {
        if (this.eclipseHasControl != bl) {
            boolean bl2 = this.eclipseHasControl;
            this.eclipseHasControl = bl;
            this.propertyChangeSupport.firePropertyChange("eclipseHasControl", new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setInterrupt(boolean bl) {
        this.interrupt = bl;
    }

    public synchronized void setRecordScenario(boolean bl) {
        if (this.recordScenario != bl) {
            boolean bl2 = this.recordScenario;
            this.recordScenario = bl;
            this.propertyChangeSupport.firePropertyChange("recordScenario", new Boolean(bl2), new Boolean(bl));
        }
    }

    public synchronized void setTerminate(boolean bl) {
        this.terminate = bl;
        if (this.getEclipseHasControl()) {
            this.visClient.exitNormal();
        }
        this.notifyAll();
    }

    public synchronized void setViewerBuildingPolicySelected(boolean bl) {
        this.viewerBuildingPolicySelected = bl;
    }

    private void startAutoResumeTimer() {
        this.autoResumeTimer = new AutoResumeTimer(this.delayModel.getValue(), this.autoResumeAction);
        this.autoResumeTimer.start();
    }

    private void stopAutoResumeTimer() {
        if (this.autoResumeTimer != null) {
            this.autoResumeTimer.stop();
            this.autoResumeTimer = null;
        }
    }

    synchronized void waitUntilEventFinishes() throws EclipseException, IOException {
        do {
            if (!this.allScenarioCommandsExecuted || this.getCurrentState() != 5 && !this.terminate) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.getCurrentState() == 7) {
                BatchGoal batchGoal = this.inEventGoal.getGoal();
                List list = batchGoal.execute(this.eclipse);
                this.inEventGoal.setResults(list);
            }
            this.getTerminate();
        } while (!this.allScenarioCommandsExecuted || this.getCurrentState() != 5 && !this.terminate);
    }

    private class RecordAction
    extends AbstractAction {
        RecordAction() {
            super("Record");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VisClientStateModel.this.setRecordScenario(VisClientStateModel.this.getRecordScenario() ^ true);
        }
    }

    private class ResumeAction
    extends AbstractAction
    implements PropertyChangeListener {
        ResumeAction() {
            super("Resume");
            this.setEnabled(false);
            VisClientStateModel.this.propertyChangeSupport.addPropertyChangeListener("currentVisClientState", this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (VisClientStateModel.this.getCurrentState() == 4) {
                VisClientStateModel.this.resume();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ((Integer)propertyChangeEvent.getNewValue() == 4) {
                this.setEnabled(true);
            }
        }
    }

    private class AutoResumeAction
    extends ResumeAction {
        AutoResumeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!VisClientStateModel.this.getInterrupt()) {
                super.actionPerformed(actionEvent);
            }
        }
    }

    private class InterruptAction
    extends AbstractAction
    implements PropertyChangeListener {
        InterruptAction() {
            super("Interrupt");
            this.setEnabled(true);
            VisClientStateModel.this.propertyChangeSupport.addPropertyChangeListener("currentVisClientState", this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            if (VisClientStateModel.this.getAutoResume() && VisClientStateModel.this.autoResumeTimer != null && VisClientStateModel.this.autoResumeTimer.isRunning()) {
                VisClientStateModel.this.stopAutoResumeTimer();
            }
            VisClientStateModel.this.setInterrupt(true);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (n == 6) {
                this.setEnabled(true);
                return;
            }
            if (!VisClientStateModel.this.getAutoResume() && n == 4) {
                this.setEnabled(false);
                return;
            }
        }
    }

    private class AutoResumeTimer
    extends Timer {
        AutoResumeTimer(int n, Action action) {
            super(n, action);
            this.setRepeats(false);
            this.setInitialDelay(n);
        }
    }

    private class InEventGoal {
        private BatchGoal goal;
        private List results;

        private InEventGoal(BatchGoal batchGoal) {
            this.setGoal(batchGoal);
        }

        /* synthetic */ InEventGoal(1 var2_2, BatchGoal batchGoal) {
            this(batchGoal);
        }

        private synchronized BatchGoal getGoal() {
            return this.goal;
        }

        private synchronized List getResults() {
            while (this.results == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.results;
        }

        private synchronized void setGoal(BatchGoal batchGoal) {
            this.goal = batchGoal;
            this.notifyAll();
        }

        private synchronized void setResults(List list) {
            this.results = list;
            this.notifyAll();
        }
    }
}

