/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.EXDRInputStream;
import com.parctechnologies.eclipse.EXDROutputStream;
import com.parctechnologies.eclipse.EclipseConnection;
import com.parctechnologies.eclipse.EclipseException;
import com.parctechnologies.eclipse.EclipseTerminatedException;
import com.parctechnologies.eclipse.Fail;
import com.parctechnologies.eclipse.FromEclipseQueue;
import com.parctechnologies.eclipse.QueueListener;
import com.parctechnologies.eclipse.ToEclipseQueue;
import com.parctechnologies.eclipse.visualisation.BatchGoal;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.InterestSpec;
import com.parctechnologies.eclipse.visualisation.ScenarioManager;
import com.parctechnologies.eclipse.visualisation.SizeEvent;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.ViewerManager;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import com.parctechnologies.eclipse.visualisation.VisException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class VisClient {
    protected VisClientStateModel stateModel;
    private FromEclipseQueue viewables_stream;
    private String viewables_stream_name;
    private FromEclipseQueue updates_stream;
    private String updates_stream_name;
    private ToEclipseQueue interest_stream;
    private String interest_stream_name;
    private EXDROutputStream interest_stream_f;
    protected Atom clientName;
    private static final Atom terminateAtom = new Atom("terminate");
    private static final Atom visProtocolSupportedAtom = new Atom("vis_protocol_supported");
    private static final Atom vcSupportAtom = new Atom("vc_support");
    private static final Atom viewGranularityAtom = new Atom("view_granularity");
    private VisClient visClient;
    private ViewerManager viewerManager;
    private static final int SUPPORTED_PROTOCOL_VERSION = 1;
    private boolean protocol_version_supported;
    private EclipseConnection eclipse;

    public VisClient(EclipseConnection eclipseConnection) {
        this.eclipse = eclipseConnection;
        try {
            this.initialise();
        }
        catch (EclipseException eclipseException) {
            this.recover_ee(eclipseException);
        }
        catch (IOException iOException) {
            this.recover_ioe(iOException);
        }
        catch (VisException visException) {
            this.recover_ve(visException);
        }
    }

    static /* synthetic */ boolean access$4(VisClient visClient) {
        return visClient.protocol_version_supported;
    }

    private void addInterestSynchronisers(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            InterestSpec interestSpec = (InterestSpec)iterator.next();
            interestSpec.getPropertyChangeSupport().addPropertyChangeListener("viewGranularity", new InterestSpecSynchroniser(interestSpec));
        }
    }

    protected void exitError() {
    }

    protected void exitNormal() {
    }

    private void expressInterestsToEclipse(String string, Collection collection) throws IOException {
        Atom atom = collection.isEmpty() ? new Atom("no") : new Atom("yes");
        this.interest_stream_f.write((Object)new CompoundTermImpl("interest", (Object)new CompoundTermImpl("viewable_create", (Object)new Atom(string)), (Object)atom, (Object)collection));
        this.interest_stream_f.flush();
    }

    private String findUnusedStreamName(String string) throws IOException, EclipseException {
        Object var2_2 = null;
        int n = 0;
        while (var2_2 == null) {
            try {
                this.eclipse.rpc("current_stream", (Object)new Atom(String.valueOf(string) + n));
            }
            catch (Fail fail) {
                return String.valueOf(string) + n;
            }
            ++n;
        }
        return String.valueOf(string) + n;
    }

    public ViewerManager getViewerManager() {
        return this.viewerManager;
    }

    private void hold() {
        try {
            this.stateModel.waitUntilEventFinishes();
        }
        catch (EclipseException eclipseException) {
            this.recover_ee(eclipseException);
        }
        catch (IOException iOException) {
            this.recover_ioe(iOException);
        }
    }

    private void initialise() throws IOException, EclipseException, VisException {
        this.initialiseStreams();
        this.initialiseQueueListeners();
        this.registerVC();
        this.initialiseStateModel();
        this.initialiseViewerManager();
        this.initialiseScenarioManager();
    }

    private void initialiseQueueListeners() throws IOException {
        this.viewables_stream.setListener((QueueListener)new ViewablesQL());
        this.updates_stream.setListener((QueueListener)new UpdatesQL());
    }

    private void initialiseScenarioManager() {
        ScenarioManager.initialise(this.stateModel);
    }

    private void initialiseStateModel() {
        this.stateModel = new VisClientStateModel(this.eclipse, this.clientName, this);
    }

    private void initialiseStreams() throws IOException, EclipseException {
        String string = String.valueOf(this.eclipse.getPeerName().functor()) + "_jvc_viewables";
        this.viewables_stream_name = this.findUnusedStreamName(string);
        this.viewables_stream = this.eclipse.getFromEclipseQueue(this.viewables_stream_name);
        this.viewables_stream.setListener((QueueListener)new ViewablesQL());
        String string2 = String.valueOf(this.eclipse.getPeerName().functor()) + "_jvc_updates";
        this.updates_stream_name = this.findUnusedStreamName(string2);
        this.updates_stream = this.eclipse.getFromEclipseQueue(this.updates_stream_name);
        this.updates_stream.setListener((QueueListener)new UpdatesQL());
        String string3 = String.valueOf(this.eclipse.getPeerName().functor()) + "_jvc_interest";
        this.interest_stream_name = this.findUnusedStreamName(string3);
        this.interest_stream = this.eclipse.getToEclipseQueue(this.interest_stream_name);
        this.interest_stream_f = new EXDROutputStream((OutputStream)this.interest_stream);
    }

    private void initialiseViewerManager() {
        this.viewerManager = new ViewerManager(this.stateModel);
    }

    private void processEvent(VisEvent visEvent) {
        Collection collection = null;
        this.stateModel.setEclipseHasControl(false);
        String string = visEvent.getViewableName();
        this.stateModel.setCurrentState(0);
        if (visEvent instanceof CreateEvent) {
            ScenarioManager.getInstance().selectPlaybackScenario(string);
            this.stateModel.setViewerBuildingPolicySelected(false);
        }
        ScenarioManager.getInstance().processEvent(visEvent);
        if (visEvent instanceof CreateEvent) {
            this.viewerManager.configureViewerBuildingPolicy(string);
        }
        this.stateModel.setCurrentState(1);
        ScenarioManager.getInstance().processEvent(visEvent);
        this.viewerManager.prepareForEvent(visEvent);
        BatchGoal batchGoal = this.viewerManager.collectPreEventGoals(visEvent);
        List list = null;
        try {
            this.stateModel.setCurrentState(2);
            ScenarioManager.getInstance().processEvent(visEvent);
            this.stateModel.setEclipseHasControl(true);
            list = batchGoal.execute(this.eclipse);
            this.stateModel.setEclipseHasControl(false);
        }
        catch (EclipseException eclipseException) {
            this.recover_ee(eclipseException);
        }
        catch (IOException iOException) {
            this.recover_ioe(iOException);
        }
        this.stateModel.setCurrentState(3);
        this.viewerManager.startEvent(visEvent, list);
        ScenarioManager.getInstance().processEvent(visEvent);
        if (this.viewerManager.shouldHold() || this.stateModel.getInterrupt()) {
            this.viewerManager.holdingEvent(visEvent);
            this.stateModel.setCurrentState(4);
            this.stateModel.setAllScenarioCommandsExecuted(false);
            ScenarioManager.getInstance().processEvent(visEvent);
            SwingUtilities.invokeLater(new AllCommandsExecuted());
            this.hold();
            this.stateModel.setInterrupt(false);
        } else {
            this.stateModel.setCurrentState(5);
        }
        ScenarioManager.getInstance().processEvent(visEvent);
        this.viewerManager.stopEvent();
        if (visEvent instanceof CreateEvent) {
            collection = this.viewerManager.getInterestSpecs(string);
            try {
                this.expressInterestsToEclipse(string, collection);
            }
            catch (IOException iOException) {
                this.recover_ioe(iOException);
            }
            this.addInterestSynchronisers(collection);
        }
        this.stateModel.setCurrentState(6);
        ScenarioManager.getInstance().processEvent(visEvent);
        this.stateModel.setEclipseHasControl(true);
        if (this.stateModel.getTerminate()) {
            this.terminate();
        }
    }

    protected void recover_ee(EclipseException eclipseException) {
        this.viewerManager.errorDialog("The following EclipseException was raised: \n\n" + (Object)((Object)eclipseException) + "\n\nThe visualisation client will now exit.");
        this.exitError();
    }

    protected void recover_ioe(IOException iOException) {
        if (iOException instanceof EclipseTerminatedException) {
            this.viewerManager.errorDialog("The ECLiPSe process which the visualisation\nclient was connected to has terminated.\n\nThe visualisation client will now exit.");
        } else {
            this.viewerManager.errorDialog("The following IOException was raised: \n\n" + iOException + "\n\nThe visualisation client will now exit.");
        }
        this.exitError();
    }

    protected void recover_ve(VisException visException) {
        this.viewerManager.errorDialog("The following VisException was raised: \n\n" + visException + "\n\nThe visualisation client will now exit.");
        this.exitError();
    }

    private void registerVC() throws IOException, EclipseException, VisException {
        int n = 0;
        this.clientName = null;
        this.eclipse.rpc("ensure_loaded(library(vc_support))");
        this.protocol_version_supported = false;
        while (this.clientName == null) {
            this.interest_stream_f.write((Object)new CompoundTermImpl("vis_protocol_version", (Object)new Integer(1)));
            this.interest_stream_f.flush();
            try {
                this.eclipse.rpc(":", (Object)new Atom("vc_support"), (Object)new CompoundTermImpl("vis_client_register", (Object)new Atom(String.valueOf(this.eclipse.getPeerName().functor()) + "_jvc_" + n), (Object)new Atom(this.viewables_stream_name), (Object)new Atom(this.updates_stream_name), (Object)new Atom(this.interest_stream_name)));
            }
            catch (Fail fail) {
                if (!this.protocol_version_supported) {
                    throw new VisException("The visualisation protocol version is not supported.");
                }
                ++n;
            }
            this.clientName = new Atom(String.valueOf(this.eclipse.getPeerName().functor()) + "_jvc_" + n);
        }
    }

    private void terminate() {
        try {
            this.interest_stream_f.write((Object)terminateAtom);
            this.interest_stream_f.flush();
            this.viewables_stream.close();
            this.updates_stream.close();
            this.interest_stream.close();
            this.eclipse.rpc((CompoundTerm)new CompoundTermImpl(":", (Object)vcSupportAtom, (Object)new CompoundTermImpl("vis_client_unregister", (Object)this.clientName)));
        }
        catch (EclipseException eclipseException) {
            this.recover_ee(eclipseException);
        }
        catch (IOException iOException) {
            this.recover_ioe(iOException);
        }
        this.exitNormal();
    }

    private abstract class VisEventsQL
    implements QueueListener {
        protected CompoundTerm eventTerm;
        EXDRInputStream eis = null;

        VisEventsQL() {
        }

        public void dataAvailable(Object object) {
            if (this.eis == null) {
                FromEclipseQueue fromEclipseQueue = (FromEclipseQueue)object;
                this.eis = new EXDRInputStream((InputStream)fromEclipseQueue);
            }
            try {
                this.eventTerm = (CompoundTerm)this.eis.readTerm();
            }
            catch (IOException iOException) {
                VisClient.this.recover_ioe(iOException);
            }
        }

        public void dataRequest(Object object) {
        }
    }

    private class UpdatesQL
    extends VisEventsQL {
        UpdatesQL() {
        }

        public void dataAvailable(Object object) {
            super.dataAvailable(object);
            VisEvent visEvent = null;
            try {
                visEvent = UpdateEvent.parseFromCompoundTerm(this.eventTerm);
            }
            catch (VisException visException) {
                VisClient.this.recover_ve(visException);
            }
            VisClient.this.processEvent(visEvent);
        }
    }

    private class ViewablesQL
    extends VisEventsQL {
        ViewablesQL() {
        }

        public void dataAvailable(Object object) {
            super.dataAvailable(object);
            if (this.eventTerm.equals(terminateAtom)) {
                VisClient.this.terminate();
                return;
            }
            if (this.eventTerm.equals(visProtocolSupportedAtom)) {
                VisClient.this.protocol_version_supported = true;
                return;
            }
            if (this.eventTerm.functor().equals("vis_protocol_version") && this.eventTerm.arity() == 1) {
                VisClient.this.protocol_version_supported = false;
                return;
            }
            this.parseAndProcess(this.eventTerm);
        }

        private void parseAndProcess(CompoundTerm compoundTerm) {
            VisEvent visEvent = null;
            try {
                CompoundTermImpl compoundTermImpl;
                visEvent = VisEvent.eventFromCompoundTerm(compoundTerm);
                if (visEvent instanceof CreateEvent) {
                    compoundTermImpl = this.sizeGoal(visEvent);
                    ((CreateEvent)visEvent).setViewableSize((List)compoundTermImpl.argCT(2).arg(2));
                }
                if (visEvent instanceof SizeEvent) {
                    compoundTermImpl = this.sizeGoal(visEvent);
                    ((SizeEvent)visEvent).setViewableSize((List)compoundTermImpl.argCT(2).arg(2));
                }
            }
            catch (VisException visException) {
                VisClient.this.recover_ve(visException);
            }
            VisClient.this.processEvent(visEvent);
        }

        private CompoundTermImpl sizeGoal(VisEvent visEvent) {
            try {
                return (CompoundTermImpl)VisClient.this.eclipse.rpc((CompoundTerm)new CompoundTermImpl(":", (Object)vcSupportAtom, (Object)new CompoundTermImpl("viewable_size", (Object)new Atom(visEvent.getViewableName()), null)));
            }
            catch (EclipseException eclipseException) {
                VisClient.this.recover_ee(eclipseException);
            }
            catch (IOException iOException) {
                VisClient.this.recover_ioe(iOException);
            }
            return null;
        }
    }

    private class InterestSpecSynchroniser
    implements PropertyChangeListener {
        private InterestSpec interestSpec;

        InterestSpecSynchroniser(InterestSpec interestSpec) {
            this.interestSpec = interestSpec;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Atom atom = VisClient.this.stateModel.getVisClientName();
            Atom atom2 = this.interestSpec.getViewable().getNameAtom();
            String string = this.interestSpec.getName();
            Atom atom3 = (Atom)propertyChangeEvent.getNewValue();
            CompoundTermImpl compoundTermImpl = new CompoundTermImpl(":", (Object)vcSupportAtom, (Object)new CompoundTermImpl("vis_client_interest_modify", (Object)atom2, (Object)atom, (Object)new Atom(string), (Object)viewGranularityAtom, (Object)atom3));
            try {
                VisClient.this.stateModel.executeInEventGoal((CompoundTerm)compoundTermImpl);
            }
            catch (VisException visException) {
                VisClient.this.recover_ve(visException);
            }
        }
    }

    private class AllCommandsExecuted
    implements Runnable {
        AllCommandsExecuted() {
        }

        public void run() {
            VisClient.this.stateModel.setAllScenarioCommandsExecuted(true);
        }
    }
}

