/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.Viewlet;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class ViewletTracker
implements Runnable {
    private JScrollPane scrollPane;
    private Collection viewlets;

    public ViewletTracker(JScrollPane jScrollPane) {
        this.scrollPane = jScrollPane;
        this.setViewlets(Collections.EMPTY_SET);
    }

    public void run() {
        if (this.viewlets.isEmpty()) {
            return;
        }
        JViewport jViewport = this.scrollPane.getViewport();
        Rectangle rectangle = jViewport.getViewRect();
        Component component = jViewport.getView();
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        JScrollBar jScrollBar2 = this.scrollPane.getVerticalScrollBar();
        Iterator iterator = this.viewlets.iterator();
        Component component2 = ((Viewlet)iterator.next()).getComponent();
        Rectangle rectangle2 = component2.getBounds();
        while (iterator.hasNext()) {
            component2 = ((Viewlet)iterator.next()).getComponent();
            rectangle2 = rectangle2.union(component2.getBounds());
        }
        if (rectangle.contains(rectangle2)) {
            return;
        }
        Rectangle rectangle3 = new Rectangle(rectangle2);
        if (rectangle2.width < rectangle.width) {
            rectangle3.x = rectangle2.x - (rectangle.width - rectangle2.width) / 2;
        }
        if (rectangle2.height < rectangle.height) {
            rectangle3.y = rectangle2.y - (rectangle.height - rectangle2.height) / 2;
        }
        rectangle2 = rectangle3;
        if (jScrollBar != null) {
            double d = (double)rectangle2.x / (double)component.getWidth();
            jScrollBar.setValue((int)(d * (double)jScrollBar.getModel().getMaximum()));
        }
        if (jScrollBar2 != null) {
            double d = (double)rectangle2.y / (double)component.getHeight();
            jScrollBar2.setValue((int)(d * (double)jScrollBar2.getModel().getMaximum()));
        }
    }

    public void setViewlets(Collection collection) {
        this.viewlets = collection;
    }
}

