/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.MouseViewletSelector;
import com.parctechnologies.eclipse.visualisation.Viewlet;
import com.parctechnologies.eclipse.visualisation.ViewletArray;
import com.parctechnologies.eclipse.visualisation.ViewletSelectable;
import com.parctechnologies.eclipse.visualisation.Zoomable;
import com.parctechnologies.eclipse.visualisation.ZoomableJPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class ViewletGrid
extends ZoomableJPanel
implements ViewletSelectable {
    private ViewletArray viewletArray;
    protected static final int INSET_PIXELS = 1;
    private Insets insets = new Insets(0, 0, 1, 1);
    private ViewletSelectedListener viewletSelectedListener;

    public ViewletGrid(ViewletArray viewletArray) {
        this.setLayout(this.initialiseLayout());
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        if (viewletArray.getNDimensions() > 2) {
            throw new IllegalArgumentException();
        }
        this.viewletArray = viewletArray;
        this.initialise();
    }

    private void addDirtyRegion(Rectangle rectangle) {
        RepaintManager.currentManager(this).addDirtyRegion(this, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void addMouseViewletSelector(MouseViewletSelector mouseViewletSelector) {
        this.addMouseListener(mouseViewletSelector);
        this.addMouseMotionListener(mouseViewletSelector);
    }

    private void expandTo(List list, List list2) {
        GridExpander gridExpander = new GridExpander(list, list2);
        try {
            SwingUtilities.invokeAndWait(gridExpander);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception " + exception + " thrown during gridExpander");
        }
        this.revalidate();
    }

    protected void expandToBody(List list, List list2) {
        int n;
        int n2;
        int n3;
        int n4 = (Integer)list.get(0);
        int n5 = (Integer)list2.get(0);
        if (this.viewletArray.getNDimensions() == 2) {
            n3 = (Integer)list.get(1);
            n2 = (Integer)list2.get(1);
        } else {
            n3 = 1;
            n2 = 1;
        }
        int n6 = 0;
        while (n6 < n4) {
            n = n3;
            while (n < n2) {
                this.initialiseViewlet(n6, n);
                ++n;
            }
            ++n6;
        }
        n6 = n4;
        while (n6 < n5) {
            n = 0;
            while (n < n2) {
                this.initialiseViewlet(n6, n);
                ++n;
            }
            ++n6;
        }
    }

    private int getNColumns() {
        if (this.viewletArray.getNDimensions() == 1) {
            return 1;
        }
        return (Integer)this.viewletArray.getSize().get(1);
    }

    private int getNRows() {
        return (Integer)this.viewletArray.getSize().get(0);
    }

    public Dimension getNormalSize() {
        int n;
        Dimension[][] dimensionArray = new Dimension[this.getNRows()][this.getNColumns()];
        int n2 = 0;
        while (n2 < this.getNRows()) {
            n = 0;
            while (n < this.getNColumns()) {
                Zoomable zoomable = (Zoomable)((Object)this.gridPointToViewlet(n, n2).getComponent());
                dimensionArray[n2][n] = zoomable.getNormalSize();
                ++n;
            }
            ++n2;
        }
        int n3 = this.getNRows();
        n2 = 0;
        while (n2 < this.getNRows()) {
            int n4 = 0;
            n = 0;
            while (n < this.getNColumns()) {
                n4 = Math.max(n4, dimensionArray[n2][n].height);
                ++n;
            }
            n3 += n4;
            ++n2;
        }
        int n5 = this.getNColumns();
        n = 0;
        while (n < this.getNColumns()) {
            int n6 = 0;
            n2 = 0;
            while (n2 < this.getNRows()) {
                n6 = Math.max(n6, dimensionArray[n2][n].width);
                ++n2;
            }
            n5 += n6;
            ++n;
        }
        return new Dimension(n5, n3);
    }

    public RepaintManager getRepaintManager() {
        return RepaintManager.currentManager(this);
    }

    public Collection getViewletsWithin(int n, int n2, int n3, int n4) {
        Point point = this.pixelPointToGridPoint(n, n2);
        Point point2 = this.pixelPointToGridPoint(n3, n4);
        int n5 = Math.min(point.x, point2.x);
        int n6 = Math.min(point.y, point2.y);
        int n7 = Math.max(point.x, point2.x);
        int n8 = Math.max(point.y, point2.y);
        LinkedList<Viewlet> linkedList = new LinkedList<Viewlet>();
        int n9 = n6;
        while (n9 <= n8) {
            int n10 = n5;
            while (n10 <= n7) {
                if (n9 >= 0 && n9 < this.getNRows() && n10 >= 0 && n10 < this.getNColumns()) {
                    Viewlet viewlet = this.gridPointToViewlet(n10, n9);
                    linkedList.add(viewlet);
                }
                ++n10;
            }
            ++n9;
        }
        return linkedList;
    }

    public Viewlet gridPointToViewlet(int n, int n2) {
        if (this.viewletArray.getNDimensions() == 1) {
            return this.viewletArray.getViewletAt(n2 + 1);
        }
        return this.viewletArray.getViewletAt(n2 + 1, n + 1);
    }

    private void initialise() {
        this.viewletSelectedListener = new ViewletSelectedListener();
        this.viewletArray.getPropertyChangeSupport().addPropertyChangeListener("arraySize", new ViewletArraySizeListener());
        this.initialiseViewlets();
    }

    protected GridBagLayout initialiseLayout() {
        return new GridBagLayout();
    }

    private void initialiseViewlet(int n, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = this.insets;
        Viewlet viewlet = this.gridPointToViewlet(n2, n);
        Component component = viewlet.getComponent();
        Zoomable zoomable = (Zoomable)((Object)component);
        viewlet.getPropertyChangeSupport().addPropertyChangeListener("selected", this.viewletSelectedListener);
        zoomable.zoomToLevel(this.getZoomLevel());
        this.add(component, gridBagConstraints);
    }

    private void initialiseViewlets() {
        int n = this.getNRows();
        int n2 = this.viewletArray.getNDimensions() == 2 ? this.getNColumns() : 1;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.initialiseViewlet(n3, n4);
                ++n4;
            }
            ++n3;
        }
    }

    public void moveDragSelectionCursorTo(int n, int n2) {
    }

    private Point pixelPointToGridPoint(int n, int n2) {
        return ((GridBagLayout)this.getLayout()).location(n, n2);
    }

    public Viewlet pixelPointToViewlet(int n, int n2) {
        Point point = this.pixelPointToGridPoint(n, n2);
        if (point.x < this.getNColumns() && point.y < this.getNRows()) {
            return this.gridPointToViewlet(point.x, point.y);
        }
        return null;
    }

    private void removeViewlet(int n, int n2) {
        Component component = this.gridPointToViewlet(n, n2).getComponent();
        this.remove(component);
    }

    public void selectSingleViewlet(Viewlet viewlet) {
    }

    public boolean shouldStartDragSelectionAt(int n, int n2) {
        return true;
    }

    private void shrinkTo(List list, List list2) {
        GridShrinker gridShrinker = new GridShrinker(list, list2);
        try {
            SwingUtilities.invokeAndWait(gridShrinker);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception " + exception + " thrown during gridShrinker");
        }
        this.revalidate();
    }

    protected void shrinkToBody(List list, List list2) {
        int n;
        int n2;
        int n3;
        int n4 = (Integer)list.get(0);
        int n5 = (Integer)list2.get(0);
        if (this.viewletArray.getNDimensions() == 2) {
            n3 = (Integer)list.get(1);
            n2 = (Integer)list2.get(1);
        } else {
            n3 = 1;
            n2 = 1;
        }
        int n6 = 0;
        while (n6 < n5) {
            n = n2;
            while (n < n3) {
                this.removeViewlet(n, n6);
                ++n;
            }
            ++n6;
        }
        n6 = n5;
        while (n6 < n4) {
            n = 0;
            while (n < n3) {
                this.removeViewlet(n, n6);
                ++n;
            }
            ++n6;
        }
    }

    public void startDragSelectionAtAnchor(int n, int n2) {
    }

    public void stopDragSelection(Collection collection) {
    }

    public void zoomToFitHeight(int n) {
        int n2 = this.getNRows();
        int n3 = this.getNormalSize().height - n2;
        int n4 = n - n2;
        float f = (float)n4 / (float)n3;
        this.zoomToLevel(f);
    }

    public void zoomToFitWidth(int n) {
        int n2 = this.getNColumns();
        int n3 = this.getNormalSize().width - n2;
        int n4 = n - n2;
        float f = (float)n4 / (float)n3;
        this.zoomToLevel(f);
    }

    public void zoomToLevel(float f) {
        this.setZoomLevel(f);
        this.zoomChildrenToLevel(f);
        this.invalidate();
    }

    private class ViewletArraySizeListener
    implements PropertyChangeListener {
        ViewletArraySizeListener() {
        }

        private boolean biggerSize(List list, List list2) {
            Iterator iterator = list.iterator();
            Iterator iterator2 = list2.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                int n2 = (Integer)iterator2.next();
                if (n2 <= n) continue;
                return false;
            }
            return true;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            List list = (List)propertyChangeEvent.getOldValue();
            List list2 = (List)propertyChangeEvent.getNewValue();
            if (this.biggerSize(list2, list)) {
                ViewletGrid.this.expandTo(list, list2);
            } else {
                ViewletGrid.this.shrinkTo(list, list2);
            }
        }
    }

    private class ViewletSelectedListener
    implements PropertyChangeListener {
        ViewletSelectedListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Viewlet viewlet = (Viewlet)propertyChangeEvent.getSource();
            Rectangle rectangle = viewlet.getComponent().getBounds();
            ViewletGrid.this.addDirtyRegion(rectangle);
        }
    }

    private class GridShrinker
    implements Runnable {
        private List oldSize;
        private List newSize;

        GridShrinker(List list, List list2) {
            this.oldSize = list;
            this.newSize = list2;
        }

        public void run() {
            ViewletGrid.this.shrinkToBody(this.oldSize, this.newSize);
        }
    }

    private class GridExpander
    implements Runnable {
        private List oldSize;
        private List newSize;

        GridExpander(List list, List list2) {
            this.oldSize = list;
            this.newSize = list2;
        }

        public void run() {
            ViewletGrid.this.expandToBody(this.oldSize, this.newSize);
        }
    }
}

