/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.DesktopViewer;
import com.parctechnologies.eclipse.visualisation.DesktopViewerBringToTopCommand;
import com.parctechnologies.eclipse.visualisation.DesktopViewerMoveViewletsCommand;
import com.parctechnologies.eclipse.visualisation.MouseViewletMover;
import com.parctechnologies.eclipse.visualisation.MouseViewletSelector;
import com.parctechnologies.eclipse.visualisation.RectQuadTree;
import com.parctechnologies.eclipse.visualisation.RootViewletComponent;
import com.parctechnologies.eclipse.visualisation.Viewlet;
import com.parctechnologies.eclipse.visualisation.ViewletMovable;
import com.parctechnologies.eclipse.visualisation.ViewletSelectable;
import com.parctechnologies.eclipse.visualisation.ZoomableJPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class ViewletDesktop
extends ZoomableJPanel
implements ViewletSelectable,
ViewletMovable {
    private static final Dimension defaultDesktopSize = new Dimension(400, 400);
    private static final Color selectionBoxColour = Color.black;
    private Dimension desktopSize;
    private RectQuadTree rectQuadTree;
    private ViewletSelectedListener viewletSelectedListener;
    private BufferedImage scratch;
    private int selectionAnchorX;
    private int selectionAnchorY;
    private int selectionCursorX;
    private int selectionCursorY;
    private int sWidth;
    private int sHeight;
    private int sTop;
    private int sLeft;
    private int moveAnchorX;
    private int moveAnchorY;
    private int pixelsMovedX;
    private int pixelsMovedY;
    private Rectangle movingBounds;
    private BufferedImage bgImage;
    private BufferedImage bgImageNormal;
    private DesktopViewer viewer;
    private Map viewletToNormalPoint;

    public ViewletDesktop(DesktopViewer desktopViewer) {
        this.viewer = desktopViewer;
        this.setDesktopSize(defaultDesktopSize);
        this.setNormalSize(defaultDesktopSize);
        this.setLayout(new DesktopLayout());
        this.initialiseRectQuadTree();
        this.viewletSelectedListener = new ViewletSelectedListener();
        this.viewletToNormalPoint = new HashMap();
    }

    private void addDirtyRegion(Rectangle rectangle) {
        RepaintManager.currentManager(this).addDirtyRegion(this, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void addMouseViewletMover(MouseViewletMover mouseViewletMover) {
        this.addMouseMotionListener(mouseViewletMover);
        this.addMouseListener(mouseViewletMover);
    }

    public void addMouseViewletSelector(MouseViewletSelector mouseViewletSelector) {
        this.addMouseMotionListener(mouseViewletSelector);
        this.addMouseListener(mouseViewletSelector);
    }

    void addNewViewletComponent(Viewlet viewlet, int n, int n2) {
        this.initialiseViewletComponent(viewlet, n, n2);
        this.addViewletComponent(viewlet);
    }

    private void addViewletComponent(Viewlet viewlet) {
        ViewletAdder viewletAdder = new ViewletAdder(viewlet);
        viewletAdder.run();
    }

    private void addViewletComponents(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addViewletComponent((Viewlet)iterator.next());
        }
    }

    public void bringViewletsToTop(Collection collection) {
        new DesktopViewerBringToTopCommand(this.viewer, collection).issue();
    }

    void bringViewletsToTopPrivate(Collection collection) {
        LinkedList<Viewlet> linkedList = new LinkedList<Viewlet>();
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Viewlet viewlet = ((RootViewletComponent)((Object)componentArray[n])).getViewlet();
            if (collection.contains(viewlet)) {
                linkedList.addFirst(viewlet);
            }
            ++n;
        }
        this.removeViewletComponents(collection);
        this.addViewletComponents(linkedList);
    }

    Dimension getDesktopSize() {
        return this.desktopSize;
    }

    public Dimension getPreferredSize() {
        return this.desktopSize;
    }

    public Collection getViewletsWithin(int n, int n2, int n3, int n4) {
        int n5 = Math.min(n, n3);
        int n6 = Math.max(n, n3);
        int n7 = Math.min(n2, n4);
        int n8 = Math.max(n2, n4);
        Rectangle rectangle = new Rectangle(n5, n7, n6 - n5, n8 - n7);
        Collection collection = this.rectQuadTree.getComponentsWithin(rectangle);
        LinkedList<Viewlet> linkedList = new LinkedList<Viewlet>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Viewlet viewlet = ((RootViewletComponent)iterator.next()).getViewlet();
            linkedList.add(viewlet);
        }
        return linkedList;
    }

    private void initialiseRectQuadTree() {
        this.rectQuadTree = new RectQuadTree(new Rectangle(this.desktopSize));
    }

    private void initialiseViewletComponent(Viewlet viewlet, int n, int n2) {
        JComponent jComponent = (JComponent)viewlet.getComponent();
        jComponent.setBorder(LineBorder.createBlackLineBorder());
        jComponent.setLocation(n, n2);
        jComponent.setSize(jComponent.getPreferredSize());
    }

    private void moveComponent(Component component, int n, int n2) {
        this.rectQuadTree.removeComponent(component);
        Point point = component.getLocation();
        this.addDirtyRegion(component.getBounds());
        component.setLocation(point.x + n, point.y + n2);
        this.viewletToNormalPoint.remove(component);
        Point point2 = new Point((int)((float)component.getX() / this.getZoomLevel()), (int)((float)component.getY() / this.getZoomLevel()));
        this.viewletToNormalPoint.put(component, point2);
        this.addDirtyRegion(component.getBounds());
        this.rectQuadTree.addComponent(component);
    }

    public void moveDragMoveBy(int n, int n2) {
        Point point = this.movePossible(n, n2);
        int n3 = point.x;
        int n4 = point.y;
        this.pixelsMovedX += n3;
        this.pixelsMovedY += n4;
        BoxDrawer boxDrawer = new BoxDrawer(true, true, this);
        boxDrawer.setUndrawRect(this.movingBounds.x, this.movingBounds.y, this.movingBounds.width, this.movingBounds.height);
        this.movingBounds.translate(n3, n4);
        boxDrawer.setDrawRect(this.movingBounds.x, this.movingBounds.y, this.movingBounds.width, this.movingBounds.height);
        SwingUtilities.invokeLater(boxDrawer);
    }

    public void moveDragSelectionCursorTo(int n, int n2) {
        BoxDrawer boxDrawer = new BoxDrawer(true, true, this);
        boxDrawer.setUndrawRect(this.sLeft, this.sTop, this.sWidth, this.sHeight);
        this.selectionCursorX = n;
        this.selectionCursorY = n2;
        this.sLeft = Math.min(this.selectionAnchorX, this.selectionCursorX);
        this.sWidth = Math.min(Math.abs(this.selectionAnchorX - this.selectionCursorX), this.desktopSize.width - this.sLeft - 1);
        this.sTop = Math.min(this.selectionAnchorY, this.selectionCursorY);
        this.sHeight = Math.min(Math.abs(this.selectionAnchorY - this.selectionCursorY), this.desktopSize.height - this.sTop - 1);
        boxDrawer.setDrawRect(this.sLeft, this.sTop, this.sWidth, this.sHeight);
        SwingUtilities.invokeLater(boxDrawer);
    }

    private Point movePossible(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (this.movingBounds.x + n < 0) {
            n3 = -this.movingBounds.x;
        } else if (this.movingBounds.x + this.movingBounds.width + n + 1 > this.desktopSize.width) {
            n3 = this.desktopSize.width - (this.movingBounds.x + this.movingBounds.width + 1);
        }
        if (this.movingBounds.y + n2 < 0) {
            n4 = -this.movingBounds.y;
        } else if (this.movingBounds.y + this.movingBounds.height + n2 + 1 > this.desktopSize.height) {
            n4 = this.desktopSize.height - (this.movingBounds.y + this.movingBounds.height + 1);
        }
        return new Point(n3, n4);
    }

    void moveViewlets(int n, int n2, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Viewlet viewlet = (Viewlet)iterator.next();
            Component component = viewlet.getComponent();
            this.moveComponent(component, n, n2);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.desktopSize.width, this.desktopSize.height);
        if (this.bgImage != null) {
            Rectangle rectangle = graphics.getClipBounds().intersection(new Rectangle(this.bgImage.getWidth(), this.bgImage.getHeight()));
            graphics.drawImage(this.bgImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height), rectangle.x, rectangle.y, this);
        }
    }

    public Viewlet pixelPointToViewlet(int n, int n2) {
        Component component = this.getComponentAt(n, n2);
        Viewlet viewlet = null;
        if (component instanceof RootViewletComponent) {
            viewlet = ((RootViewletComponent)((Object)component)).getViewlet();
        }
        return viewlet;
    }

    void removeViewletComponent(Viewlet viewlet) {
        ViewletRemover viewletRemover = new ViewletRemover(viewlet);
        viewletRemover.run();
    }

    void removeViewletComponents(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeViewletComponent((Viewlet)iterator.next());
        }
    }

    public void selectSingleViewlet(Viewlet viewlet) {
        LinkedList<Viewlet> linkedList = new LinkedList<Viewlet>();
        linkedList.add(viewlet);
        this.bringViewletsToTop(linkedList);
    }

    void setBackgroundImage(BufferedImage bufferedImage) {
        this.bgImageNormal = bufferedImage;
        this.setNormalSize(new Dimension(Math.max(this.getNormalSize().width, bufferedImage.getWidth()), Math.max(this.getNormalSize().height, bufferedImage.getHeight())));
        int n = (int)((float)bufferedImage.getHeight() * this.getZoomLevel());
        int n2 = (int)((float)bufferedImage.getWidth() * this.getZoomLevel());
        this.bgImage = new BufferedImage(n2, n, 4);
        Image image = this.getZoomLevel() != 1.0f ? this.bgImageNormal.getScaledInstance(n2, n, 4) : this.bgImageNormal;
        this.bgImage.getGraphics().drawImage(image, 0, 0, this);
        this.setDesktopSize(new Dimension((int)((float)this.getNormalSize().width * this.getZoomLevel()), (int)((float)this.getNormalSize().height * this.getZoomLevel())));
        this.repaint();
    }

    private void setDesktopSize(Dimension dimension) {
        if (!dimension.equals(this.desktopSize)) {
            this.desktopSize = dimension;
            this.initialiseRectQuadTree();
            this.scratch = new BufferedImage(this.desktopSize.width, this.desktopSize.height, 4);
            Component[] componentArray = this.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.rectQuadTree.addComponent(componentArray[n]);
                ++n;
            }
            this.revalidate();
        }
    }

    public boolean shouldStartDragMoveAt(int n, int n2) {
        Viewlet viewlet = this.pixelPointToViewlet(n, n2);
        if (viewlet == null) {
            return false;
        }
        return viewlet.getSelected();
    }

    public boolean shouldStartDragSelectionAt(int n, int n2) {
        return this.pixelPointToViewlet(n, n2) == null;
    }

    public void startDragMoveAtAnchor(int n, int n2, Collection collection) {
        this.moveAnchorX = n;
        this.moveAnchorY = n2;
        this.pixelsMovedX = 0;
        this.pixelsMovedY = 0;
        this.movingBounds = new Rectangle(n, n2, 1, 1);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Rectangle rectangle = ((Viewlet)iterator.next()).getComponent().getBounds();
            this.movingBounds = this.movingBounds.union(rectangle);
        }
        BoxDrawer boxDrawer = new BoxDrawer(true, false, this);
        boxDrawer.setDrawRect(this.movingBounds.x, this.movingBounds.y, this.movingBounds.width, this.movingBounds.height);
        SwingUtilities.invokeLater(boxDrawer);
    }

    public void startDragSelectionAtAnchor(int n, int n2) {
        this.selectionAnchorX = n;
        this.selectionAnchorY = n2;
        this.selectionCursorX = n;
        this.selectionCursorY = n2;
        this.sWidth = Math.abs(this.selectionAnchorX - this.selectionCursorX);
        this.sHeight = Math.abs(this.selectionAnchorY - this.selectionCursorY);
        this.sLeft = Math.min(this.selectionAnchorX, this.selectionCursorX);
        this.sTop = Math.min(this.selectionAnchorY, this.selectionCursorY);
        BoxDrawer boxDrawer = new BoxDrawer(true, false, this);
        boxDrawer.setDrawRect(this.sLeft, this.sTop, this.sWidth, this.sHeight);
        SwingUtilities.invokeLater(boxDrawer);
    }

    public void stopDragMoveAt(int n, int n2, Collection collection) {
        BoxDrawer boxDrawer = new BoxDrawer(false, true, this);
        boxDrawer.setUndrawRect(this.movingBounds.x, this.movingBounds.y, this.movingBounds.width, this.movingBounds.height);
        SwingUtilities.invokeLater(boxDrawer);
        new DesktopViewerMoveViewletsCommand(this.viewer, collection, this.pixelsMovedX, this.pixelsMovedY).issue();
    }

    public void stopDragSelection(Collection collection) {
        BoxDrawer boxDrawer = new BoxDrawer(false, true, this);
        boxDrawer.setUndrawRect(this.sLeft, this.sTop, this.sWidth, this.sHeight);
        SwingUtilities.invokeLater(boxDrawer);
        this.bringViewletsToTop(collection);
    }

    public void zoomToLevel(float f) {
        super.zoomToLevel(f);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Point point = (Point)this.viewletToNormalPoint.get(componentArray[n]);
            componentArray[n].setLocation((int)((float)point.x * this.getZoomLevel()), (int)((float)point.y * this.getZoomLevel()));
            ++n;
        }
        if (this.bgImageNormal != null) {
            this.setBackgroundImage(this.bgImageNormal);
        } else {
            this.setDesktopSize(new Dimension((int)((float)this.getNormalSize().width * this.getZoomLevel()), (int)((float)this.getNormalSize().height * this.getZoomLevel())));
            this.repaint();
        }
    }

    private class DesktopLayout
    implements LayoutManager {
        DesktopLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Component[] componentArray = ViewletDesktop.this.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (!componentArray[n].getSize().equals(componentArray[n].getPreferredSize())) {
                    ViewletDesktop.this.rectQuadTree.removeComponent(componentArray[n]);
                    componentArray[n].setSize(componentArray[n].getPreferredSize());
                    ViewletDesktop.this.rectQuadTree.addComponent(componentArray[n]);
                }
                ++n;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return ViewletDesktop.this.desktopSize;
        }

        public Dimension preferredLayoutSize(Container container) {
            return ViewletDesktop.this.desktopSize;
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    private class ViewletAdder
    implements Runnable {
        private Viewlet viewlet;

        ViewletAdder(Viewlet viewlet) {
            this.viewlet = viewlet;
        }

        public void run() {
            this.viewlet.getPropertyChangeSupport().addPropertyChangeListener(ViewletDesktop.this.viewletSelectedListener);
            JComponent jComponent = (JComponent)this.viewlet.getComponent();
            ViewletDesktop.this.add((Component)jComponent, 0);
            jComponent.revalidate();
            jComponent.repaint();
            ViewletDesktop.this.rectQuadTree.addComponent(jComponent);
            Point point = new Point((int)((float)jComponent.getX() / ViewletDesktop.this.getZoomLevel()), (int)((float)jComponent.getY() / ViewletDesktop.this.getZoomLevel()));
            ViewletDesktop.this.viewletToNormalPoint.put(jComponent, point);
        }
    }

    private class ViewletRemover
    implements Runnable {
        private Viewlet viewlet;

        ViewletRemover(Viewlet viewlet) {
            this.viewlet = viewlet;
        }

        public void run() {
            this.viewlet.getPropertyChangeSupport().removePropertyChangeListener(ViewletDesktop.this.viewletSelectedListener);
            JComponent jComponent = (JComponent)this.viewlet.getComponent();
            ViewletDesktop.this.rectQuadTree.removeComponent(jComponent);
            ViewletDesktop.this.remove(jComponent);
            ViewletDesktop.this.viewletToNormalPoint.remove(jComponent);
            ViewletDesktop.this.addDirtyRegion(jComponent.getBounds());
        }
    }

    private class BoxDrawer
    implements Runnable {
        Component c;
        boolean draw;
        boolean undraw;
        int dLeft;
        int dTop;
        int dWidth;
        int dHeight;
        int uLeft;
        int uTop;
        int uWidth;
        int uHeight;
        Rectangle drawRectTop;
        Rectangle drawRectLeft;
        Rectangle drawRectBottom;
        Rectangle drawRectRight;
        Rectangle undrawRectTop;
        Rectangle undrawRectLeft;
        Rectangle undrawRectBottom;
        Rectangle undrawRectRight;

        public BoxDrawer(boolean bl, boolean bl2, Component component) {
            this.draw = bl;
            this.undraw = bl2;
            this.c = component;
        }

        public void run() {
            if (this.undraw && !this.draw) {
                ViewletDesktop.this.paintImmediately(this.undrawRectTop);
                ViewletDesktop.this.paintImmediately(this.undrawRectLeft);
                ViewletDesktop.this.paintImmediately(this.undrawRectBottom);
                ViewletDesktop.this.paintImmediately(this.undrawRectRight);
                return;
            }
            Graphics graphics = ViewletDesktop.this.getGraphics();
            if (this.draw && this.undraw) {
                Graphics graphics2 = ViewletDesktop.this.scratch.getGraphics();
                Rectangle rectangle = new Rectangle(this.dLeft, this.dTop, this.dWidth + 1, this.dHeight + 1);
                rectangle = rectangle.union(new Rectangle(this.uLeft, this.uTop, this.uWidth + 1, this.uHeight + 1));
                rectangle = rectangle.intersection(new Rectangle(ViewletDesktop.this.desktopSize));
                Rectangle rectangle2 = new Rectangle(ViewletDesktop.this.desktopSize);
                Rectangle rectangle3 = this.drawRectLeft.union(this.undrawRectLeft).intersection(rectangle2);
                Rectangle rectangle4 = this.drawRectTop.union(this.undrawRectTop).intersection(rectangle2);
                Rectangle rectangle5 = this.drawRectBottom.union(this.undrawRectBottom).intersection(rectangle2);
                Rectangle rectangle6 = this.drawRectRight.union(this.undrawRectRight).intersection(rectangle2);
                graphics2.setClip(rectangle3);
                this.c.paint(graphics2);
                graphics2.setClip(rectangle4);
                this.c.paint(graphics2);
                graphics2.setClip(rectangle5);
                this.c.paint(graphics2);
                graphics2.setClip(rectangle6);
                this.c.paint(graphics2);
                graphics2.setColor(selectionBoxColour);
                graphics2.setXORMode(Color.white);
                graphics2.setClip(rectangle);
                graphics2.drawRect(this.dLeft, this.dTop, this.dWidth, this.dHeight);
                graphics.drawImage(ViewletDesktop.this.scratch.getSubimage(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height), rectangle3.x, rectangle3.y, this.c);
                graphics.drawImage(ViewletDesktop.this.scratch.getSubimage(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height), rectangle4.x, rectangle4.y, this.c);
                graphics.drawImage(ViewletDesktop.this.scratch.getSubimage(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height), rectangle5.x, rectangle5.y, this.c);
                graphics.drawImage(ViewletDesktop.this.scratch.getSubimage(rectangle6.x, rectangle6.y, rectangle6.width, rectangle6.height), rectangle6.x, rectangle6.y, this.c);
                return;
            }
            if (this.draw && !this.undraw) {
                graphics.setColor(selectionBoxColour);
                graphics.setXORMode(Color.white);
                graphics.drawRect(this.dLeft, this.dTop, this.dWidth, this.dHeight);
            }
        }

        public void setDrawRect(int n, int n2, int n3, int n4) {
            this.dLeft = n;
            this.dTop = n2;
            this.dWidth = n3;
            this.dHeight = n4;
            this.drawRectLeft = new Rectangle(n, n2, 1, n4 + 1);
            this.drawRectTop = new Rectangle(n, n2, n3 + 1, 1);
            this.drawRectBottom = new Rectangle(n, n2 + n4, n3 + 1, 1);
            this.drawRectRight = new Rectangle(n + n3, n2, 1, n4 + 1);
        }

        public void setUndrawRect(int n, int n2, int n3, int n4) {
            this.uLeft = n;
            this.uTop = n2;
            this.uWidth = n3;
            this.uHeight = n4;
            this.undrawRectLeft = new Rectangle(n, n2, 1, n4 + 1);
            this.undrawRectTop = new Rectangle(n, n2, n3 + 1, 1);
            this.undrawRectBottom = new Rectangle(n, n2 + n4, n3 + 1, 1);
            this.undrawRectRight = new Rectangle(n + n3, n2, 1, n4 + 1);
        }
    }

    private class ViewletSelectedListener
    implements PropertyChangeListener {
        ViewletSelectedListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Viewlet viewlet = (Viewlet)propertyChangeEvent.getSource();
            Rectangle rectangle = viewlet.getComponent().getBounds();
            ViewletDesktop.this.addDirtyRegion(rectangle);
        }
    }
}

