/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.visualisation.ContainerViewer;
import com.parctechnologies.eclipse.visualisation.ContractEvent;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.ExpandEvent;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.Viewlet;
import com.parctechnologies.eclipse.visualisation.ViewletArray;
import com.parctechnologies.eclipse.visualisation.ViewletFactory;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public abstract class ViewletArrayViewer
extends ContainerViewer {
    private ViewletFactory viewletFactory;
    private ViewletArray viewletArray;
    private final Atom vcSupportAtom = new Atom("vc_support");

    public ViewletArrayViewer(ViewletFactory viewletFactory, VisClientStateModel visClientStateModel, Viewable viewable) {
        super(visClientStateModel, viewable);
        this.setViewletFactory(viewletFactory);
    }

    protected Collection getAllViewlets() {
        return this.viewletArray.getAllViewlets();
    }

    protected ViewletArray getViewletArray() {
        return this.viewletArray;
    }

    public Viewlet getViewletAt(List list) {
        return this.viewletArray.getViewletAt(list);
    }

    protected ViewletFactory getViewletFactory() {
        return this.viewletFactory;
    }

    public Collection getViewletsAt(List list) {
        LinkedList<Viewlet> linkedList = new LinkedList<Viewlet>();
        linkedList.add(this.getViewletAt(list));
        return linkedList;
    }

    private void prepareForCreate(CreateEvent createEvent) {
        this.viewletArray = new ViewletArray(createEvent.getViewableSize(), createEvent.getViewableType().getFixityList(), this.viewletFactory, this.getSymRef());
    }

    public void prepareForEvent(VisEvent visEvent) {
        if (visEvent instanceof CreateEvent) {
            this.prepareForCreate((CreateEvent)visEvent);
        }
        if (visEvent instanceof ExpandEvent) {
            this.prepareForExpand((ExpandEvent)visEvent);
        }
        super.prepareForEvent(visEvent);
    }

    private void prepareForExpand(ExpandEvent expandEvent) {
        this.viewletArray.startExpandDimension(expandEvent.getExpandingDimension());
    }

    public void setViewletFactory(ViewletFactory viewletFactory) {
        this.viewletFactory = viewletFactory;
    }

    public void startEvent(VisEvent visEvent, List list) {
        if (visEvent instanceof CreateEvent) {
            super.startEvent(visEvent, list);
            int n = 1;
            while (n <= this.viewletArray.getNDimensions()) {
                this.viewletArray.setLocationNames(n, this.getLocationNames(n));
                ++n;
            }
            return;
        }
        if (visEvent instanceof ExpandEvent) {
            super.startEvent(visEvent, list);
            int n = ((ExpandEvent)visEvent).getExpandingDimension();
            this.viewletArray.finishExpandDimension(n);
            return;
        }
        super.startEvent(visEvent, list);
    }

    private void stopContract(ContractEvent contractEvent) {
        this.viewletArray.shrinkTo(contractEvent.getViewableSize());
    }

    public void stopEvent() {
        if (this.getCurrentEvent() instanceof ContractEvent) {
            this.stopContract((ContractEvent)this.getCurrentEvent());
        }
        super.stopEvent();
    }
}

