/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.visualisation.SymRef;
import com.parctechnologies.eclipse.visualisation.Viewlet;
import com.parctechnologies.eclipse.visualisation.ViewletFactory;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class ViewletArray {
    private static final String fixedString = "fixed";
    private static final String flexibleString = "flexible";
    private PropertyChangeSupport propertyChangeSupport;
    private List oldSize;
    private List[] locationNames;
    private String topLevelFixity;
    private List wholeSize;
    private List location;
    private List subFixity;
    private ViewletFactory viewletFactory;
    private Elements elements;
    private SymRef parentSymRef;

    public ViewletArray(List list, List list2, ViewletFactory viewletFactory, SymRef symRef) {
        this(list, list2, viewletFactory, Collections.EMPTY_LIST, symRef);
    }

    private ViewletArray(List list, List list2, ViewletFactory viewletFactory, List list3, SymRef symRef) {
        int n = (Integer)list.get(0);
        this.wholeSize = new LinkedList(list);
        this.topLevelFixity = (String)list2.get(0);
        List list4 = list.subList(1, list.size());
        this.subFixity = list2.subList(1, list2.size());
        this.viewletFactory = viewletFactory;
        this.location = list3;
        this.parentSymRef = symRef;
        this.elements = this.topLevelFixity.equals(fixedString) ? new FixedElements(n) : new FlexibleElements(n);
        int n2 = 0;
        while (n2 < n) {
            LinkedList<Integer> linkedList = new LinkedList<Integer>(list3);
            linkedList.add(new Integer(n2 + 1));
            this.elements.set(n2, ViewletArray.createSubArray(list4, this.subFixity, viewletFactory, linkedList, symRef));
            ++n2;
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.locationNames = new List[this.getNDimensions()];
    }

    private static Object createSubArray(List list, List list2, ViewletFactory viewletFactory, List list3, SymRef symRef) {
        if (list.isEmpty()) {
            Viewlet viewlet = viewletFactory.build();
            viewlet.setElementReference(new CompoundTermImpl("element", (Object)list3));
            viewlet.setSymRef(new SymRef(viewlet, symRef, list3));
            return viewlet;
        }
        return new ViewletArray(list, list2, viewletFactory, list3, symRef);
    }

    void finishExpandDimension(int n) {
        this.propertyChangeSupport.firePropertyChange("arraySize", this.oldSize, this.wholeSize);
    }

    public Collection getAllViewlets() {
        List list = this.elements.toList();
        if (this.wholeSize.size() == 1) {
            return list;
        }
        Iterator iterator = list.iterator();
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            ViewletArray viewletArray = (ViewletArray)iterator.next();
            linkedList.addAll(viewletArray.getAllViewlets());
        }
        return linkedList;
    }

    private Object getElement(List list) {
        Object object = this.elements.get((Integer)list.get(0) - 1);
        if (list.size() == 1) {
            return object;
        }
        List list2 = list.subList(1, list.size());
        return ((ViewletArray)object).getElement(list2);
    }

    String getLocationName(int n, int n2) {
        return (String)this.getLocationNames(n).get(n2 - 1);
    }

    List getLocationNames(int n) {
        return this.locationNames[n - 1];
    }

    public int getNDimensions() {
        return this.getSize().size();
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public List getSize() {
        return this.wholeSize;
    }

    public Viewlet getViewletAt(int n) {
        if (this.getSize().size() != 1) {
            return null;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(new Integer(n));
        return this.getViewletAt(linkedList);
    }

    public Viewlet getViewletAt(int n, int n2) {
        if (this.getSize().size() != 2) {
            return null;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(new Integer(n));
        linkedList.add(new Integer(n2));
        return this.getViewletAt(linkedList);
    }

    public Viewlet getViewletAt(List list) {
        if (list.size() != this.getSize().size()) {
            throw new IllegalArgumentException();
        }
        return (Viewlet)this.getElement(list);
    }

    void setLocationNames(int n, List list) {
        this.locationNames[n - 1] = list;
    }

    void shrinkTo(List list) {
        this.propertyChangeSupport.firePropertyChange("arraySize", this.wholeSize, list);
        if (this.wholeSize.equals(list)) {
            return;
        }
        int n = (Integer)list.get(0);
        this.elements.shrinkTo(n);
        if (this.wholeSize.size() > 1) {
            List list2 = list.subList(1, list.size());
            int n2 = 0;
            while (n2 < this.elements.size()) {
                ((ViewletArray)this.elements.get(n2)).shrinkTo(list2);
                ++n2;
            }
        }
        this.wholeSize = new LinkedList(list);
    }

    void startExpandDimension(int n) {
        Integer n2 = (Integer)this.wholeSize.get(n - 1);
        Integer n3 = new Integer(n2 + 1);
        this.oldSize = new LinkedList(this.wholeSize);
        this.wholeSize.set(n - 1, n3);
        if (n > 1) {
            int n4 = 0;
            while (n4 < this.elements.size()) {
                ((ViewletArray)this.elements.get(n4)).startExpandDimension(n - 1);
                ++n4;
            }
        } else {
            List list = this.wholeSize.subList(1, this.wholeSize.size());
            LinkedList<Integer> linkedList = new LinkedList<Integer>(this.location);
            linkedList.add(n3);
            this.elements.expand(ViewletArray.createSubArray(list, this.subFixity, this.viewletFactory, linkedList, this.parentSymRef));
        }
    }

    private abstract class Elements {
        Elements() {
        }

        void expand(Object object) {
        }

        abstract Object get(int var1);

        abstract void set(int var1, Object var2);

        void shrinkTo(int n) {
        }

        abstract int size();

        abstract List toList();
    }

    private class FixedElements
    extends Elements {
        private Object[] elements;

        FixedElements(int n) {
            this.elements = new Object[n];
        }

        Object get(int n) {
            return this.elements[n];
        }

        void set(int n, Object object) {
            this.elements[n] = object;
        }

        int size() {
            return this.elements.length;
        }

        List toList() {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            int n = 0;
            while (n < this.elements.length) {
                linkedList.add(this.elements[n]);
                ++n;
            }
            return linkedList;
        }
    }

    private class FlexibleElements
    extends Elements {
        private Vector elements;

        FlexibleElements(int n) {
            this.elements = new Vector(n);
            this.elements.setSize(n);
        }

        void expand(Object object) {
            this.elements.add(object);
        }

        Object get(int n) {
            return this.elements.get(n);
        }

        void set(int n, Object object) {
            this.elements.set(n, object);
        }

        void shrinkTo(int n) {
            while (this.size() > n) {
                this.elements.remove(n);
            }
        }

        int size() {
            return this.elements.size();
        }

        List toList() {
            return new LinkedList(this.elements);
        }
    }
}

