/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.visualisation.ElementType;
import com.parctechnologies.eclipse.visualisation.VisException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ViewableType
implements Serializable {
    private ElementType elementType;
    private List fixityList;

    private ViewableType(List list, ElementType elementType) {
        this.setElementType(elementType);
        this.setFixityList(list);
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public List getFixityList() {
        return this.fixityList;
    }

    public int getNDimensions() {
        return this.fixityList.size();
    }

    static ViewableType parseFromCompoundTerm(CompoundTerm compoundTerm) throws VisException {
        if (compoundTerm.functor().equals("array") || compoundTerm.arity() == 2) {
            Atom atom;
            Collection collection = (Collection)compoundTerm.arg(1);
            ArrayList<String> arrayList = new ArrayList<String>(collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                atom = (Atom)iterator.next();
                arrayList.add(atom.functor());
            }
            atom = (CompoundTerm)compoundTerm.arg(2);
            return new ViewableType(new LinkedList(arrayList), ElementType.parseFromCompoundTerm((CompoundTerm)atom));
        }
        throw new VisException("Could not parse viewable type from term " + compoundTerm);
    }

    protected void setElementType(ElementType elementType) {
        this.elementType = elementType;
    }

    protected void setFixityList(List list) {
        this.fixityList = list;
    }
}

