/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.ZoomableJPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class TextPanel
extends ZoomableJPanel
implements PropertyChangeListener {
    private String text;
    private Font size1Font;

    public TextPanel(PropertyChangeSupport propertyChangeSupport, String string) {
        this(string);
        propertyChangeSupport.addPropertyChangeListener("text", this);
    }

    public TextPanel(String string) {
        this.setPreferredSize(new Dimension(100, 30));
        this.size1Font = this.getFont();
        this.setNormalSize(this.getPreferredSize());
        this.setOpaque(false);
        this.text = string;
    }

    public void fitToText() {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        FontMetrics fontMetrics2 = ((Component)this).getFontMetrics(this.size1Font);
        this.setPreferredSize(new Dimension(fontMetrics.stringWidth(this.text), this.getPreferredSize().height));
        this.setNormalSize(new Dimension(fontMetrics2.stringWidth(this.text), this.getNormalSize().height));
        this.invalidate();
    }

    private Font getZoomedFont() {
        Font font = this.size1Font.deriveFont((float)this.size1Font.getSize() * this.getZoomLevel());
        return font;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = fontMetrics.stringWidth(this.text);
        int n4 = fontMetrics.getHeight();
        int n5 = n <= n3 ? 0 : (n - n3) / 2;
        int n6 = n2 <= n4 ? 0 : (n2 - n4) / 2;
        graphics.drawString(this.text, n5, n6 + fontMetrics.getAscent());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setText((String)propertyChangeEvent.getNewValue());
    }

    private void setText(String string) {
        this.text = string;
        this.revalidate();
        this.repaint();
    }

    public void setZoomLevel(float f) {
        super.setZoomLevel(f);
        this.setFont(this.getZoomedFont());
    }
}

