/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.BooleanPropertyModel;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.ExpandEvent;
import com.parctechnologies.eclipse.visualisation.ScrollingViewletGrid;
import com.parctechnologies.eclipse.visualisation.TableViewerZoomToFitHeightCommand;
import com.parctechnologies.eclipse.visualisation.TableViewerZoomToFitWidthCommand;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.ViewerSetBooleanPropertyCommand;
import com.parctechnologies.eclipse.visualisation.ViewletArrayViewer;
import com.parctechnologies.eclipse.visualisation.ViewletFactory;
import com.parctechnologies.eclipse.visualisation.ViewletTracker;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;

public class TableViewer
extends ViewletArrayViewer {
    private ScrollingViewletGrid scrollingViewletGrid;
    private boolean trackExpansions = false;
    private ViewletTracker viewletTracker;

    TableViewer(ViewletFactory viewletFactory, VisClientStateModel visClientStateModel, Viewable viewable) {
        super(viewletFactory, visClientStateModel, viewable);
        this.initialiseMenu();
    }

    public Component getComponent() {
        return this.scrollingViewletGrid;
    }

    public boolean getTrackExpansions() {
        return this.trackExpansions;
    }

    protected ViewletTracker getViewletTracker() {
        return this.viewletTracker;
    }

    protected Action getZoomToFitHeightAction() {
        return new ZoomToFitHeightAction(this);
    }

    protected Action getZoomToFitWidthAction() {
        return new ZoomToFitWidthAction(this);
    }

    private void initialiseComponent() {
        this.scrollingViewletGrid = new ScrollingViewletGrid(this.getViewletArray(), this);
        this.viewletTracker = new ViewletTracker(this.scrollingViewletGrid);
    }

    private void initialiseMenu() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Track expansions");
        ((AbstractButton)jCheckBoxMenuItem).setModel(new BooleanPropertyModel("trackExpansions", this, this.getPropertyChangeSupport()));
        this.addMenuItem("Options", jCheckBoxMenuItem);
    }

    private void scrollToTrackExpansion(ExpandEvent expandEvent) {
        this.scrollingViewletGrid.scrollToTrackExpansion(expandEvent.getExpandingDimension());
    }

    public void setTrackExpansions(boolean bl) {
        new ViewerSetBooleanPropertyCommand(this, "trackExpansions", bl).issue();
    }

    public void setTrackExpansionsPrivate(boolean bl) {
        boolean bl2 = this.trackExpansions;
        this.trackExpansions = bl;
        this.getPropertyChangeSupport().firePropertyChange("trackExpansions", bl2, bl);
    }

    public void startEvent(VisEvent visEvent, List list) {
        if (visEvent instanceof UpdateEvent) {
            super.startEvent(visEvent, list);
            return;
        }
        if (visEvent instanceof CreateEvent) {
            super.startEvent(visEvent, list);
            this.initialiseComponent();
            return;
        }
        if (visEvent instanceof ExpandEvent) {
            super.startEvent(visEvent, list);
            if (this.trackExpansions) {
                this.scrollToTrackExpansion((ExpandEvent)visEvent);
            }
            return;
        }
        super.startEvent(visEvent, list);
    }

    void zoomToFitHeight() {
        this.scrollingViewletGrid.zoomToFitHeight();
        this.scrollingViewletGrid.revalidate();
    }

    void zoomToFitWidth() {
        this.scrollingViewletGrid.zoomToFitWidth();
        this.scrollingViewletGrid.revalidate();
    }

    public void zoomToLevel(float f) {
        this.scrollingViewletGrid.zoomToLevel(f);
        this.scrollingViewletGrid.revalidate();
    }

    private class ZoomToFitWidthAction
    extends AbstractAction {
        private TableViewer viewer;

        ZoomToFitWidthAction(TableViewer tableViewer2) {
            super("Zoom to fit width");
            this.viewer = tableViewer2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new TableViewerZoomToFitWidthCommand(this.viewer).issue();
        }
    }

    private class ZoomToFitHeightAction
    extends AbstractAction {
        private TableViewer viewer;

        ZoomToFitHeightAction(TableViewer tableViewer2) {
            super("Zoom to fit height");
            this.viewer = tableViewer2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new TableViewerZoomToFitHeightCommand(this.viewer).issue();
        }
    }
}

