/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.InvalidSymRefException;
import com.parctechnologies.eclipse.visualisation.SymRefable;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SymRef
implements Serializable {
    public static final SymRef ROOT = new SymRef();
    protected List path;
    private static Node root = new Node();

    private SymRef() {
        this.path = new LinkedList();
        this.path.add("ROOT");
    }

    public SymRef(SymRefable symRefable, SymRef symRef, Object object) {
        this.path = Node.addChild(symRef.path, object, symRefable);
    }

    public SymRef(SymRefable symRefable, Object object) {
        this.path = Node.put(object, symRefable);
    }

    private SymRef(List list) {
        this.path = list;
    }

    public boolean equals(Object object) {
        if (object instanceof SymRef) {
            return this.toString().equals(((SymRef)object).toString());
        }
        return false;
    }

    public static synchronized SymRefable get(SymRef symRef) throws InvalidSymRefException {
        SymRefable symRefable;
        if (Node.containsKey(symRef.path) && (symRefable = Node.findNode(symRef.path).get()) != null) {
            return symRefable;
        }
        throw new InvalidSymRefException(symRef);
    }

    public SymRef getRoot() {
        LinkedList linkedList = new LinkedList();
        linkedList.add(this.path.get(0));
        return new SymRef(linkedList);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.path.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("/").append(iterator.next());
        }
        return stringBuffer.toString();
    }

    private static class Node {
        public Node parent;
        public Object id;
        public Reference val_ref;
        public Map children;

        public Node() {
            this(null, null, null);
        }

        public Node(Node node, Object object, Object object2) {
            this.parent = node;
            this.id = object;
            this.val_ref = new SoftReference<Object>(object2);
            this.children = new HashMap();
            if (node != null && node.children != null) {
                node.children.put(object, this);
            }
        }

        public static List addChild(List list, Object object, Object object2) {
            Node node = Node.findNode(list);
            if (node == null) {
                return null;
            }
            String string = String.valueOf(object.toString()) + "_" + node.children.size();
            Node node2 = new Node(node, string, object2);
            LinkedList<String> linkedList = new LinkedList<String>(list);
            linkedList.add(string);
            return linkedList;
        }

        public static boolean containsKey(List list) {
            return Node.matchKey(list) == list.size();
        }

        public static Node findNode(List list) {
            Node node = root;
            int n = list.size();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (node.children.containsKey(e)) {
                    node = (Node)node.children.get(e);
                    continue;
                }
                return null;
            }
            return node;
        }

        public final SymRefable get() {
            return (SymRefable)this.val_ref.get();
        }

        public static int matchKey(List list) {
            Node node = root;
            int n = list.size();
            int n2 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!node.children.containsKey(e)) break;
                node = (Node)node.children.get(e);
                ++n2;
            }
            return n2;
        }

        public static List put(Object object, Object object2) {
            Node node = new Node(root, object, object2);
            LinkedList<Object> linkedList = new LinkedList<Object>();
            linkedList.add(object);
            return linkedList;
        }
    }
}

