/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.ContainerViewer;
import com.parctechnologies.eclipse.visualisation.MouseViewletMenuUpPopper;
import com.parctechnologies.eclipse.visualisation.MouseViewletSelector;
import com.parctechnologies.eclipse.visualisation.TextPanel;
import com.parctechnologies.eclipse.visualisation.ViewletArray;
import com.parctechnologies.eclipse.visualisation.ViewletGrid;
import com.parctechnologies.eclipse.visualisation.Zoomable;
import com.parctechnologies.eclipse.visualisation.ZoomableJPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class ScrollingViewletGrid
extends JScrollPane {
    private ScrollableViewletGrid viewletGrid;
    private ViewletArray viewletArray;
    private RowHeader rowHeader;
    private ColumnHeader columnHeader;
    private static final Color dimensionHeaderColor = new Color(230, 230, 230);

    public ScrollingViewletGrid(ViewletArray viewletArray, ContainerViewer containerViewer) {
        this.viewletArray = viewletArray;
        this.viewletGrid = new ScrollableViewletGrid(viewletArray);
        MouseViewletSelector mouseViewletSelector = new MouseViewletSelector(containerViewer, this.viewletGrid);
        MouseViewletMenuUpPopper mouseViewletMenuUpPopper = new MouseViewletMenuUpPopper(containerViewer, this.viewletGrid);
        JPanel jPanel = this.wrapJPanel(this.viewletGrid);
        jPanel.addMouseListener(new MouseClickClearSelectionListener(containerViewer));
        this.setViewportView(jPanel);
        this.initialiseHeaders();
    }

    private void initialiseHeaders() {
        this.rowHeader = new RowHeader();
        this.rowHeader.setLocationNames(this.viewletArray.getLocationNames(1));
        if (this.viewletArray.getNDimensions() > 1) {
            this.columnHeader = new ColumnHeader();
            this.columnHeader.setLocationNames(this.viewletArray.getLocationNames(2));
        }
        this.setRowHeaderView(this.wrapJPanel(this.rowHeader));
        if (this.viewletArray.getNDimensions() > 1) {
            this.setColumnHeaderView(this.wrapJPanel(this.columnHeader));
        }
    }

    void scrollToTrackExpansion(int n) {
        ExpandScroller expandScroller = new ExpandScroller(n);
        try {
            SwingUtilities.invokeAndWait(expandScroller);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception " + exception + " thrown during ExpandScroller");
        }
    }

    private JPanel wrapJPanel(Component component) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add(component, gridBagConstraints);
        return jPanel;
    }

    public void zoomToFitHeight() {
        int n;
        int n2 = this.getHeight() - 5;
        int n3 = n = this.viewletGrid.getNormalSize().height;
        int n4 = 0;
        float f = 0.0f;
        if (this.viewletArray.getNDimensions() > 1) {
            n4 = this.columnHeader.getNormalSize().height;
            f = (float)n4 / (float)(n3 += n4);
        }
        float f2 = (float)n / (float)n3;
        int n5 = (int)(f2 * (float)n2);
        this.viewletGrid.zoomToFitHeight(n5);
        this.rowHeader.zoomToFitHeight(n5);
        if (this.viewletArray.getNDimensions() > 1) {
            int n6 = (int)(f * (float)n2);
            this.columnHeader.zoomToFitHeight(n6);
        }
    }

    public void zoomToFitWidth() {
        int n = this.getWidth() - 5;
        int n2 = this.rowHeader.getNormalSize().width;
        int n3 = this.viewletGrid.getNormalSize().width;
        int n4 = n2 + n3;
        float f = (float)n2 / (float)n4;
        float f2 = (float)n3 / (float)n4;
        int n5 = (int)(f * (float)n);
        int n6 = (int)(f2 * (float)n);
        this.viewletGrid.zoomToFitWidth(n6);
        if (this.viewletArray.getNDimensions() > 1) {
            this.columnHeader.zoomToFitWidth(n6);
        }
        this.rowHeader.zoomToFitWidth(n5);
    }

    public void zoomToLevel(float f) {
        this.rowHeader.zoomToLevel(f);
        if (this.viewletArray.getNDimensions() > 1) {
            this.columnHeader.zoomToLevel(f);
        }
        this.viewletGrid.zoomToLevel(f);
    }

    private class ExpandScroller
    implements Runnable {
        private int expandingDimension;

        ExpandScroller(int n) {
            this.expandingDimension = n;
        }

        public void run() {
            JViewport jViewport = ScrollingViewletGrid.this.getViewport();
            Rectangle rectangle = jViewport.getViewRect();
            Component component = jViewport.getView();
            Rectangle rectangle2 = this.expandingDimension == 1 ? new Rectangle(rectangle.x, component.getHeight() - 2, rectangle.width, 1) : new Rectangle(component.getWidth() - 2, rectangle.y, 1, rectangle.height);
            jViewport.scrollRectToVisible(rectangle2);
        }
    }

    private class MouseClickClearSelectionListener
    extends MouseAdapter {
        ContainerViewer containerViewer;

        MouseClickClearSelectionListener(ContainerViewer containerViewer) {
            this.containerViewer = containerViewer;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.containerViewer.clearSelection();
            ScrollingViewletGrid.this.viewletGrid.repaint();
        }
    }

    private class ScrollableViewletGrid
    extends ViewletGrid {
        private MyGridBagLayout layout = (MyGridBagLayout)this.getLayout();

        ScrollableViewletGrid(ViewletArray viewletArray) {
            super(viewletArray);
        }

        protected void expandToBody(List list, List list2) {
            int n;
            int n2;
            super.expandToBody(list, list2);
            int n3 = (Integer)list.get(0);
            int n4 = (Integer)list2.get(0);
            if (n3 != n4) {
                ScrollingViewletGrid.this.rowHeader.addLocationName(ScrollingViewletGrid.this.viewletArray.getLocationName(1, n4));
            }
            if (ScrollingViewletGrid.this.viewletArray.getNDimensions() == 2 && (n2 = ((Integer)list.get(1)).intValue()) != (n = ((Integer)list2.get(1)).intValue())) {
                ScrollingViewletGrid.this.columnHeader.addLocationName(ScrollingViewletGrid.this.viewletArray.getLocationName(2, n));
            }
        }

        int getInsetPixels() {
            return 1;
        }

        protected GridBagLayout initialiseLayout() {
            return new MyGridBagLayout();
        }

        protected void shrinkToBody(List list, List list2) {
            super.shrinkToBody(list, list2);
            int n = (Integer)list2.get(0);
            ScrollingViewletGrid.this.rowHeader.shrinkTo(n);
            if (ScrollingViewletGrid.this.viewletArray.getNDimensions() == 2) {
                int n2 = (Integer)list2.get(1);
                ScrollingViewletGrid.this.columnHeader.shrinkTo(n2);
            }
        }

        private void synchroniseHeaderDimensions() {
            int[] nArray = this.layout.getLayoutDimensions()[0];
            int[] nArray2 = this.layout.getLayoutDimensions()[1];
            ScrollingViewletGrid.this.rowHeader.setRowHeights(nArray2);
            ScrollingViewletGrid.this.rowHeader.invalidate();
            if (ScrollingViewletGrid.this.viewletArray.getNDimensions() > 1) {
                ScrollingViewletGrid.this.columnHeader.setColumnWidths(nArray);
                ScrollingViewletGrid.this.columnHeader.invalidate();
            }
        }

        private class MyGridBagLayout
        extends GridBagLayout {
            MyGridBagLayout() {
            }

            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                ScrollableViewletGrid.this.synchroniseHeaderDimensions();
            }
        }
    }

    private class DimensionHeader
    extends ZoomableJPanel {
        private Integer dimNumber;
        protected GridBagConstraints gbc;
        protected LinkedList headerComponents;

        DimensionHeader(int n) {
            super(new GridBagLayout());
            this.dimNumber = new Integer(n);
            this.gbc = new GridBagConstraints();
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 1.0;
            this.gbc.fill = 1;
            this.gbc.insets = new Insets(0, 0, ScrollingViewletGrid.this.viewletGrid.getInsetPixels(), ScrollingViewletGrid.this.viewletGrid.getInsetPixels());
            this.headerComponents = new LinkedList();
        }

        void addLocationName(String string) {
            JComponent jComponent = this.createHeader(string);
            this.headerComponents.add(jComponent);
            this.add((Component)jComponent, this.gbc);
        }

        protected JComponent createHeader(String string) {
            TextPanel textPanel = new TextPanel(string);
            textPanel.setBackground(dimensionHeaderColor);
            textPanel.setOpaque(true);
            textPanel.zoomToLevel(this.getZoomLevel());
            return textPanel;
        }

        void setLocationNames(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.addLocationName((String)iterator.next());
            }
        }

        void shrinkTo(int n) {
            while (this.headerComponents.size() > n) {
                this.remove((Component)this.headerComponents.removeLast());
            }
        }

        public void zoomToLevel(float f) {
            this.setZoomLevel(f);
            this.zoomChildrenToLevel(f);
            this.invalidate();
        }
    }

    private class RowHeader
    extends DimensionHeader {
        RowHeader() {
            super(1);
        }

        void addLocationName(String string) {
            this.gbc.gridy = this.headerComponents.size();
            super.addLocationName(string);
        }

        public Dimension getNormalSize() {
            Zoomable zoomable = (Zoomable)this.headerComponents.get(0);
            return new Dimension(zoomable.getNormalSize().width, ((ScrollingViewletGrid)ScrollingViewletGrid.this).viewletGrid.getNormalSize().height);
        }

        void setRowHeights(int[] nArray) {
            Iterator iterator = this.headerComponents.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                JComponent jComponent = (JComponent)iterator.next();
                int n2 = nArray[n] - ScrollingViewletGrid.this.viewletGrid.getInsetPixels();
                Dimension dimension = jComponent.getPreferredSize();
                if (n2 != dimension.height) {
                    jComponent.setPreferredSize(new Dimension(dimension.width, n2));
                    jComponent.invalidate();
                }
                ++n;
            }
        }

        void zoomToFitHeight(int n) {
            int n2 = ScrollingViewletGrid.this.viewletGrid.getInsetPixels() * this.headerComponents.size();
            int n3 = this.getNormalSize().height - n2;
            int n4 = n - n2;
            float f = (float)n4 / (float)n3;
            this.zoomToLevel(f);
        }

        void zoomToFitWidth(int n) {
            int n2 = ScrollingViewletGrid.this.viewletGrid.getInsetPixels();
            int n3 = this.getNormalSize().width - n2;
            int n4 = n - n2;
            float f = (float)n4 / (float)n3;
            this.zoomToLevel(f);
        }
    }

    private class ColumnHeader
    extends DimensionHeader {
        ColumnHeader() {
            super(2);
        }

        protected void addLocationName(String string) {
            this.gbc.gridx = this.headerComponents.size();
            super.addLocationName(string);
        }

        public Dimension getNormalSize() {
            Zoomable zoomable = (Zoomable)this.headerComponents.get(0);
            return new Dimension(((ScrollingViewletGrid)ScrollingViewletGrid.this).viewletGrid.getNormalSize().width, zoomable.getNormalSize().height);
        }

        void setColumnWidths(int[] nArray) {
            Iterator iterator = this.headerComponents.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                JComponent jComponent = (JComponent)iterator.next();
                Dimension dimension = jComponent.getPreferredSize();
                int n2 = nArray[n] - ScrollingViewletGrid.this.viewletGrid.getInsetPixels();
                if (n2 != dimension.width) {
                    jComponent.setPreferredSize(new Dimension(n2, dimension.height));
                    jComponent.invalidate();
                }
                ++n;
            }
        }

        void zoomToFitHeight(int n) {
            int n2 = ScrollingViewletGrid.this.viewletGrid.getInsetPixels();
            int n3 = this.getNormalSize().height - n2;
            int n4 = n - n2;
            float f = (float)n4 / (float)n3;
            this.zoomToLevel(f);
        }

        void zoomToFitWidth(int n) {
            int n2 = ScrollingViewletGrid.this.viewletGrid.getInsetPixels() * this.headerComponents.size();
            int n3 = this.getNormalSize().width - n2;
            int n4 = n - n2;
            float f = (float)n4 / (float)n3;
            this.zoomToLevel(f);
        }
    }
}

