/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.Command;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.DestroyEvent;
import com.parctechnologies.eclipse.visualisation.PolicySelectedCommand;
import com.parctechnologies.eclipse.visualisation.Scenario;
import com.parctechnologies.eclipse.visualisation.ScenarioIterator;
import com.parctechnologies.eclipse.visualisation.SymRefCommand;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ScenarioManager {
    private HashMap scenarioMap = new HashMap();
    private HashMap iteratorMap = new HashMap();
    private static VisClientStateModel stateModel;
    private static ScenarioManager instance;
    private File defaultScenarioDirectory;

    private ScenarioManager() {
    }

    public void clearIteratorForPlayback(Object object) {
        this.iteratorMap.remove(object);
    }

    public Scenario getExactScenarioForName(Object object) {
        if (this.scenarioMap.containsKey(object)) {
            return (Scenario)this.scenarioMap.get(object);
        }
        return null;
    }

    public static synchronized ScenarioManager getInstance() {
        if (instance == null) {
            instance = new ScenarioManager();
        }
        return instance;
    }

    public Scenario getMatchingScenarioForPlayback(Object object) {
        if (this.scenarioMap.containsKey(object)) {
            Scenario scenario = (Scenario)this.scenarioMap.get(object);
            return scenario;
        }
        return null;
    }

    public ScenarioIterator getPlayingIteratorForName(Object object) {
        if (this.iteratorMap.containsKey(object)) {
            ScenarioIterator scenarioIterator = (ScenarioIterator)this.iteratorMap.get(object);
            return scenarioIterator;
        }
        return null;
    }

    public Collection getScenarioForName(String string) {
        Scenario scenario = null;
        if (this.scenarioMap.containsKey(string)) {
            scenario = (Scenario)this.scenarioMap.get(string);
        } else {
            scenario = new Scenario(string);
            this.registerScenario(scenario);
        }
        LinkedList<Scenario> linkedList = new LinkedList<Scenario>();
        linkedList.add(scenario);
        return linkedList;
    }

    public VisClientStateModel getVisClientStateModel() {
        return stateModel;
    }

    public static void initialise(VisClientStateModel visClientStateModel) {
        stateModel = visClientStateModel;
    }

    public Scenario loadScenario(Object object) {
        ScenarioFileChooser scenarioFileChooser = new ScenarioFileChooser(object);
        if (this.defaultScenarioDirectory != null) {
            scenarioFileChooser.setCurrentDirectory(this.defaultScenarioDirectory);
        }
        int n = scenarioFileChooser.showOpenDialog(null);
        Scenario scenario = null;
        if (n == 0) {
            File file = scenarioFileChooser.getSelectedFile();
            if (file.exists()) {
                try {
                    scenario = this.loadScenarioFromFile(file);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "File \n" + file + "\n exception occured during load\n" + iOException, "Error in Visualisation Client", 0);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    JOptionPane.showMessageDialog(null, "File \n" + file + "\n exception occured during load\n" + classNotFoundException, "Error in Visualisation Client", 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "File \n" + file + "\ndoes not exist", "Error in Visualisation Client", 0);
            }
        }
        this.defaultScenarioDirectory = scenarioFileChooser.getCurrentDirectory();
        return scenario;
    }

    public void loadScenarioForPlayback() {
        Scenario scenario = this.loadScenario("");
        if (scenario != null) {
            this.registerScenario(scenario);
            JOptionPane.showMessageDialog(null, "Successfully loaded scenario for viewable \"" + scenario.getViewableName() + "\"");
        }
    }

    private Scenario loadScenarioFromFile(File file) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        Scenario scenario = (Scenario)objectInputStream.readObject();
        fileInputStream.close();
        return scenario;
    }

    public void processCommand(Command command) {
        if (stateModel.getRecordScenario()) {
            Scenario scenario;
            String string = null;
            if (command instanceof SymRefCommand) {
                string = ((SymRefCommand)command).getSymRef().getRoot().toString();
                string = string.substring(1);
            } else if (command instanceof PolicySelectedCommand) {
                string = ((PolicySelectedCommand)command).getViewableName();
            }
            if (string != null && (scenario = this.getExactScenarioForName(string)) != null) {
                scenario.add(command, stateModel.getCurrentState());
            }
        }
    }

    public void processEvent(VisEvent visEvent) {
        Object object;
        if (stateModel.getRecordScenario() && stateModel.getCurrentState() == 0) {
            if (visEvent instanceof CreateEvent) {
                this.registerScenario(new Scenario(visEvent.getViewableName()));
            }
            if ((object = this.getExactScenarioForName(visEvent.getViewableName())) != null) {
                ((Scenario)object).add(visEvent, stateModel.getCurrentState());
            }
        }
        if ((object = this.getPlayingIteratorForName(visEvent.getViewableName())) != null && ((ScenarioIterator)object).matches(visEvent)) {
            ((ScenarioIterator)object).play(stateModel.getCurrentState());
        }
        if (visEvent instanceof DestroyEvent && stateModel.getCurrentState() == 6) {
            this.iteratorMap.remove(visEvent.getViewableName());
        }
    }

    public void registerIteratorForPlayback(Scenario scenario, Object object) {
        this.iteratorMap.put(object, scenario.iterator());
    }

    public void registerScenario(Scenario scenario) {
        this.scenarioMap.put(scenario.getViewableName(), scenario);
    }

    void saveScenario(Scenario scenario) {
        int n;
        Object object = scenario.getViewableName();
        ScenarioFileChooser scenarioFileChooser = new ScenarioFileChooser(object);
        if (this.defaultScenarioDirectory != null) {
            scenarioFileChooser.setCurrentDirectory(this.defaultScenarioDirectory);
        }
        if ((n = scenarioFileChooser.showSaveDialog(null)) == 0) {
            File file = scenarioFileChooser.getSelectedFile();
            if (!file.toString().endsWith(".scenario") && !file.toString().endsWith(".SCENARIO")) {
                file = new File(String.valueOf(file.toString()) + ".scenario");
            }
            if (!file.exists() || JOptionPane.showConfirmDialog(null, "File already exists\nReplace " + file + "?", "File exists", 0) == 0) {
                try {
                    this.saveScenarioToFile(file, scenario);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "File \n" + file + "\n exception occured during save\n" + iOException, "Error in Visualisation Client", 0);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    JOptionPane.showMessageDialog(null, "File \n" + file + "\n exception occured during save\n" + classNotFoundException, "Error in Visualisation Client", 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "File \n" + file + "\nwas not saved", "Warning", 0);
            }
        }
        this.defaultScenarioDirectory = scenarioFileChooser.getCurrentDirectory();
    }

    public void saveScenarioToDisk() {
        Scenario scenario = this.selectScenario();
        if (scenario != null) {
            this.saveScenario(scenario);
        }
    }

    private void saveScenarioToFile(File file, Scenario scenario) throws IOException, ClassNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(scenario);
        fileOutputStream.close();
    }

    public void selectPlaybackScenario(String string) {
        Scenario scenario = this.getMatchingScenarioForPlayback(string);
        boolean bl = false;
        if (scenario != null) {
            int n = JOptionPane.showConfirmDialog(null, "Reinstate saved visualisation preferences for viewable " + string + "?", "Visualisation preferences", 0);
            boolean bl2 = bl = n == 0;
        }
        if (bl) {
            ScenarioManager.getInstance().registerIteratorForPlayback(scenario, string);
        } else {
            ScenarioManager.getInstance().clearIteratorForPlayback(string);
        }
    }

    Scenario selectScenario() {
        Object object;
        Scenario scenario = null;
        Scenario[] scenarioArray = new Scenario[this.scenarioMap.size()];
        Object[] objectArray = new Object[this.scenarioMap.size()];
        int n = 0;
        if (objectArray.length == 0) {
            JOptionPane.showMessageDialog(null, "There are no currently no scenarios in memory.");
            return null;
        }
        Iterator iterator = this.scenarioMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Scenario scenario2 = (Scenario)this.scenarioMap.get(object);
            objectArray[n] = object.toString();
            scenarioArray[n] = scenario2;
            ++n;
        }
        object = JOptionPane.showInputDialog(null, "Select the scenario to save", "Input", 1, null, objectArray, objectArray[0]);
        if (object == null) {
            return null;
        }
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == object) {
                scenario = scenarioArray[n];
                break;
            }
            ++n;
        }
        return scenario;
    }

    private static class ScenarioFileFilter
    extends FileFilter {
        Object viewableName;

        public ScenarioFileFilter(Object object) {
            this.viewableName = object;
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.toString().endsWith(".scenario") || file.toString().endsWith(".SCENARIO");
        }

        public String getDescription() {
            return "Visualisation Scenario";
        }
    }

    private static class ScenarioFileChooser
    extends JFileChooser
    implements PropertyChangeListener {
        Object viewableName;

        ScenarioFileChooser(Object object) {
            this.viewableName = object;
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            this.setFileSelectionMode(0);
            this.setFileFilter(new ScenarioFileFilter(object));
            ((Component)this).addPropertyChangeListener("directoryChanged", this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setSelectedFile(null);
        }
    }
}

