/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import java.awt.Component;
import java.awt.Label;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

class RectQuadTree {
    private RectQuadTree[] child;
    private int type;
    private static final int NONEMPTY_LEAF = 0;
    private static final int EMPTY_LEAF = 1;
    private static final int INTERIOR = 2;
    private static final int DEFAULT_MIN_SIDE = 20;
    private Collection intersectingComponents;
    private Rectangle bounds;
    private int maxDepth;

    public RectQuadTree(Rectangle rectangle) {
        this(rectangle, RectQuadTree.depthGivenBounds(rectangle));
    }

    private RectQuadTree(Rectangle rectangle, int n) {
        this.bounds = rectangle;
        this.maxDepth = n;
        this.type = 1;
    }

    public void addComponent(Component component) {
        this.addComponent(component, component.getBounds());
    }

    private void addComponent(Component component, Rectangle rectangle) {
        if (this.type == 1) {
            if (this.maxDepth == 0 || rectangle.contains(this.bounds)) {
                this.type = 0;
                this.initialiseIntersectingComponents();
                this.intersectingComponents.add(component);
            } else {
                this.type = 2;
                this.initialiseChild();
                this.addComponent(component, rectangle);
            }
            return;
        }
        if (this.type == 0) {
            if (this.maxDepth == 0 || rectangle.contains(this.bounds)) {
                this.intersectingComponents.add(component);
            } else {
                this.type = 2;
                this.initialiseChild();
                int n = 0;
                while (n < this.child.length) {
                    this.child[n].type = 0;
                    this.child[n].initialiseIntersectingComponents();
                    this.child[n].intersectingComponents.addAll(this.intersectingComponents);
                    ++n;
                }
                this.intersectingComponents = null;
                this.addComponent(component, rectangle);
            }
            return;
        }
        if (this.type == 2) {
            int n = 0;
            while (n < this.child.length) {
                if (rectangle.intersects(this.child[n].bounds)) {
                    this.child[n].addComponent(component, rectangle);
                }
                ++n;
            }
        }
    }

    private void addIntersectingComponents(Collection collection) {
        if (this.type == 1) {
            return;
        }
        if (this.type == 0) {
            collection.addAll(this.intersectingComponents);
            return;
        }
        if (this.type == 2) {
            int n = 0;
            while (n < this.child.length) {
                this.child[n].addIntersectingComponents(collection);
                ++n;
            }
        }
    }

    private void addIntersectingComponentsWithin(Rectangle rectangle, Collection collection) {
        if (this.type == 1) {
            return;
        }
        if (this.type == 0) {
            Iterator iterator = this.intersectingComponents.iterator();
            while (iterator.hasNext()) {
                Component component = (Component)iterator.next();
                if (!component.getBounds().intersects(rectangle)) continue;
                collection.add(component);
            }
        }
        if (this.type == 2) {
            int n = 0;
            while (n < this.child.length) {
                if (rectangle.contains(this.child[n].bounds)) {
                    this.child[n].addIntersectingComponents(collection);
                } else if (rectangle.intersects(this.child[n].bounds)) {
                    this.child[n].addIntersectingComponentsWithin(rectangle, collection);
                }
                ++n;
            }
        }
    }

    private static int depthGivenBounds(Rectangle rectangle) {
        int n = Math.min(rectangle.width, rectangle.height);
        int n2 = (int)(Math.log((double)n / 20.0) / Math.log(2.0)) - 1;
        return n2;
    }

    public Collection getComponentsWithin(Rectangle rectangle) {
        HashSet hashSet = new HashSet();
        this.addIntersectingComponentsWithin(rectangle, hashSet);
        return hashSet;
    }

    private void initialiseChild() {
        this.child = new RectQuadTree[4];
        int n = this.bounds.width / 2;
        int n2 = this.bounds.width - n;
        int n3 = this.bounds.height / 2;
        int n4 = this.bounds.height - n3;
        int n5 = this.maxDepth - 1;
        this.child[0] = new RectQuadTree(new Rectangle(this.bounds.x, this.bounds.y, n, n3), n5);
        this.child[1] = new RectQuadTree(new Rectangle(this.bounds.x + n, this.bounds.y, n2, n3), n5);
        this.child[2] = new RectQuadTree(new Rectangle(this.bounds.x, this.bounds.y + n3, n, n4), n5);
        this.child[3] = new RectQuadTree(new Rectangle(this.bounds.x + n, this.bounds.y + n3, n2, n4), n5);
    }

    private void initialiseIntersectingComponents() {
        this.intersectingComponents = new HashSet();
    }

    public void removeComponent(Component component) {
        this.removeComponent(component, component.getBounds());
    }

    private void removeComponent(Component component, Rectangle rectangle) {
        if (this.type == 1) {
            return;
        }
        if (this.type == 0) {
            this.intersectingComponents.remove(component);
            if (this.intersectingComponents.isEmpty()) {
                this.intersectingComponents = null;
                this.type = 1;
            }
            return;
        }
        if (this.type == 2) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.child.length) {
                if (rectangle.intersects(this.child[n3].bounds)) {
                    this.child[n3].removeComponent(component, rectangle);
                }
                if (this.child[n3].type == 1) {
                    ++n;
                } else if (this.child[n3].type == 0) {
                    ++n2;
                }
                ++n3;
            }
            if (n == this.child.length) {
                this.type = 1;
                this.child = null;
                return;
            }
            if (n2 == this.child.length && this.child[0].intersectingComponents.equals(this.child[1].intersectingComponents) && this.child[1].intersectingComponents.equals(this.child[2].intersectingComponents) && this.child[2].intersectingComponents.equals(this.child[3].intersectingComponents)) {
                boolean bl = true;
                Iterator iterator = this.child[0].intersectingComponents.iterator();
                while (iterator.hasNext() && bl) {
                    Component component2 = (Component)iterator.next();
                    if (component2.getBounds().contains(this.bounds)) continue;
                    bl = false;
                }
                if (bl) {
                    this.type = 0;
                    this.intersectingComponents = this.child[0].intersectingComponents;
                    this.child = null;
                }
            }
        }
    }

    private static void test() {
        int n;
        int n2;
        int n3 = 7;
        int n4 = 50;
        int n5 = 25;
        int n6 = 2000;
        int n7 = 2000;
        int n8 = 2000;
        Random random = new Random(1L);
        Component[] componentArray = new Component[n4];
        RectQuadTree rectQuadTree = new RectQuadTree(new Rectangle(0, 0, n7, n8), n3);
        int n9 = 0;
        while (n9 < n4) {
            componentArray[n9] = new Label("");
            n2 = random.nextInt(n7 / 2);
            n = random.nextInt(n8 / 2);
            componentArray[n9].setBounds(random.nextInt(n7 - n2), random.nextInt(n8 - n), n2, n);
            rectQuadTree.addComponent(componentArray[n9]);
            System.out.println("added component to rqt with bounds " + componentArray[n9].getBounds());
            ++n9;
        }
        System.out.println("Tests for 20 x 20: " + RectQuadTree.tests(rectQuadTree, n6, componentArray, 20, 20));
        System.out.println("Tests for 20 x 500: " + RectQuadTree.tests(rectQuadTree, n6, componentArray, 20, 500));
        System.out.println("Tests for 500 x 20: " + RectQuadTree.tests(rectQuadTree, n6, componentArray, 500, 20));
        System.out.println("Tests for 500 x 500: " + RectQuadTree.tests(rectQuadTree, n6, componentArray, 500, 500));
        int n10 = 0;
        while (n10 < n5) {
            int n11 = random.nextInt(n4);
            rectQuadTree.removeComponent(componentArray[n11]);
            n2 = random.nextInt(n7 / 2);
            n = random.nextInt(n8 / 2);
            componentArray[n11] = new Label("");
            componentArray[n11].setBounds(random.nextInt(n7 - n2), random.nextInt(n8 - n), n2, n);
            rectQuadTree.addComponent(componentArray[n11]);
            System.out.println("replaced component : new one has bounds " + componentArray[n11].getBounds());
            ++n10;
        }
        System.out.println("Post-replacement tests for 20 x 20: " + RectQuadTree.tests(rectQuadTree, n6, componentArray, 20, 20));
        System.out.println("Post-replacement tests for 20 x 500: " + RectQuadTree.tests(rectQuadTree, n6, componentArray, 20, 500));
        System.out.println("Post-replacement tests for 500 x 20: " + RectQuadTree.tests(rectQuadTree, n6, componentArray, 500, 20));
        System.out.println("Post-replacement tests for 500 x 500: " + RectQuadTree.tests(rectQuadTree, n6, componentArray, 500, 500));
    }

    private static boolean test(RectQuadTree rectQuadTree, Rectangle rectangle, Component[] componentArray) {
        Collection collection = rectQuadTree.getComponentsWithin(rectangle);
        HashSet<Component> hashSet = new HashSet<Component>();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n].getBounds().intersects(rectangle)) {
                hashSet.add(componentArray[n]);
            }
            ++n;
        }
        return collection.equals(hashSet);
    }

    private static boolean tests(RectQuadTree rectQuadTree, int n, Component[] componentArray, int n2, int n3) {
        Random random = new Random(2L);
        boolean bl = true;
        int n4 = 0;
        while (n4 < n) {
            Rectangle rectangle = new Rectangle(random.nextInt(rectQuadTree.bounds.width - n2), random.nextInt(rectQuadTree.bounds.height - n3), n2, n3);
            if (!RectQuadTree.test(rectQuadTree, rectangle, componentArray)) {
                System.out.println("test failed for testRect = " + rectangle);
                bl = false;
            }
            ++n4;
        }
        return bl;
    }
}

