/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.ContainerViewer;
import com.parctechnologies.eclipse.visualisation.Viewlet;
import com.parctechnologies.eclipse.visualisation.ViewletSelectable;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Collection;

public class MouseViewletSelector
extends MouseAdapter
implements MouseMotionListener {
    protected ContainerViewer containerViewer;
    private int anchorX;
    private int anchorY;
    private boolean anchorSet;
    protected static final int LEFT_BUTTON_MASK = 16;
    private static final int RIGHT_BUTTON_MASK = 4;

    public MouseViewletSelector(ContainerViewer containerViewer, ViewletSelectable viewletSelectable) {
        this.containerViewer = containerViewer;
        viewletSelectable.addMouseViewletSelector(this);
        this.resetAnchor();
    }

    private synchronized int getAnchorX() {
        return this.anchorX;
    }

    private synchronized int getAnchorY() {
        return this.anchorY;
    }

    private synchronized boolean isAnchorSet() {
        return this.anchorSet;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 16 && this.isAnchorSet()) {
            ViewletSelectable viewletSelectable = (ViewletSelectable)mouseEvent.getSource();
            Collection collection = viewletSelectable.getViewletsWithin(this.getAnchorX(), this.getAnchorY(), mouseEvent.getX(), mouseEvent.getY());
            this.containerViewer.setSelection(collection);
            viewletSelectable.moveDragSelectionCursorTo(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        ViewletSelectable viewletSelectable;
        if ((mouseEvent.getModifiers() & 0x10) == 16 && (viewletSelectable = (ViewletSelectable)mouseEvent.getSource()).shouldStartDragSelectionAt(mouseEvent.getX(), mouseEvent.getY())) {
            Viewlet viewlet = viewletSelectable.pixelPointToViewlet(mouseEvent.getX(), mouseEvent.getY());
            this.startDragSelection(viewletSelectable, mouseEvent, viewlet);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        ViewletSelectable viewletSelectable = (ViewletSelectable)mouseEvent.getSource();
        if ((mouseEvent.getModifiers() & 4) == 4) {
            Viewlet viewlet = viewletSelectable.pixelPointToViewlet(mouseEvent.getX(), mouseEvent.getY());
            if (!this.containerViewer.getSelection().contains(viewlet)) {
                this.selectSingle(viewletSelectable, mouseEvent, viewlet);
            }
            return;
        }
        if ((mouseEvent.getModifiers() & 0x10) == 16 && this.isAnchorSet()) {
            this.resetAnchor();
            viewletSelectable.stopDragSelection(this.containerViewer.getSelection());
        }
    }

    private synchronized void resetAnchor() {
        this.setAnchorSet(false);
    }

    private void selectSingle(ViewletSelectable viewletSelectable, MouseEvent mouseEvent, Viewlet viewlet) {
        this.containerViewer.clearSelection();
        if (viewlet != null) {
            this.containerViewer.addToSelection(viewlet);
            viewletSelectable.selectSingleViewlet(viewlet);
        }
        if (mouseEvent.getSource() instanceof Component) {
            ((Component)mouseEvent.getSource()).requestFocus();
        }
    }

    private synchronized void setAnchor(int n, int n2) {
        this.setAnchorSet(true);
        this.anchorX = n;
        this.anchorY = n2;
    }

    private synchronized void setAnchorSet(boolean bl) {
        this.anchorSet = bl;
    }

    private void startDragSelection(ViewletSelectable viewletSelectable, MouseEvent mouseEvent, Viewlet viewlet) {
        this.selectSingle(viewletSelectable, mouseEvent, viewlet);
        this.setAnchor(mouseEvent.getX(), mouseEvent.getY());
        viewletSelectable.startDragSelectionAtAnchor(mouseEvent.getX(), mouseEvent.getY());
    }
}

