/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.ViewletMovable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Collection;

public class MouseViewletMover
extends MouseAdapter
implements MouseMotionListener {
    private int anchorX;
    private int anchorY;
    private int cursorX;
    private int cursorY;
    private boolean anchorSet;
    private static final int LEFT_BUTTON_MASK = 16;
    private Collection selection;

    public MouseViewletMover(ViewletMovable viewletMovable, Collection collection) {
        this.selection = collection;
        viewletMovable.addMouseViewletMover(this);
        this.resetAnchor();
    }

    private synchronized int getAnchorX() {
        return this.anchorX;
    }

    private synchronized int getAnchorY() {
        return this.anchorY;
    }

    private synchronized boolean isAnchorSet() {
        return this.anchorSet;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 16 && this.isAnchorSet()) {
            ViewletMovable viewletMovable = (ViewletMovable)mouseEvent.getSource();
            viewletMovable.moveDragMoveBy(mouseEvent.getX() - this.cursorX, mouseEvent.getY() - this.cursorY);
            this.cursorX = mouseEvent.getX();
            this.cursorY = mouseEvent.getY();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        ViewletMovable viewletMovable;
        if ((mouseEvent.getModifiers() & 0x10) == 16 && (viewletMovable = (ViewletMovable)mouseEvent.getSource()).shouldStartDragMoveAt(mouseEvent.getX(), mouseEvent.getY())) {
            this.setAnchor(mouseEvent.getX(), mouseEvent.getY());
            viewletMovable.startDragMoveAtAnchor(mouseEvent.getX(), mouseEvent.getY(), this.selection);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        ViewletMovable viewletMovable = (ViewletMovable)mouseEvent.getSource();
        if ((mouseEvent.getModifiers() & 0x10) == 16 && this.isAnchorSet()) {
            this.resetAnchor();
            viewletMovable.stopDragMoveAt(mouseEvent.getX(), mouseEvent.getY(), this.selection);
        }
    }

    private synchronized void resetAnchor() {
        this.setAnchorSet(false);
    }

    private synchronized void setAnchor(int n, int n2) {
        this.setAnchorSet(true);
        this.anchorX = n;
        this.anchorY = n2;
        this.cursorX = n;
        this.cursorY = n2;
    }

    private synchronized void setAnchorSet(boolean bl) {
        this.anchorSet = bl;
    }
}

