/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.visualisation.ActionButton;
import com.parctechnologies.eclipse.visualisation.ContainerViewer;
import com.parctechnologies.eclipse.visualisation.ContractEvent;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.DesktopViewerImportBackgroundCommand;
import com.parctechnologies.eclipse.visualisation.DesktopViewerInsertViewletCommand;
import com.parctechnologies.eclipse.visualisation.MouseViewletMenuUpPopper;
import com.parctechnologies.eclipse.visualisation.MouseViewletMover;
import com.parctechnologies.eclipse.visualisation.MouseViewletSelector;
import com.parctechnologies.eclipse.visualisation.SymRef;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewerZoomCommand;
import com.parctechnologies.eclipse.visualisation.Viewlet;
import com.parctechnologies.eclipse.visualisation.ViewletDesktop;
import com.parctechnologies.eclipse.visualisation.ViewletFactory;
import com.parctechnologies.eclipse.visualisation.ViewletSelectable;
import com.parctechnologies.eclipse.visualisation.ViewletTracker;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import com.parctechnologies.eclipse.visualisation.VisException;
import com.parctechnologies.eclipse.visualisation.Zoomable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class DesktopViewer
extends ContainerViewer {
    private Collection viewletFactories;
    private Map indexToViewlets;
    private Collection allViewlets;
    private ViewletDesktop viewletDesktop;
    private JScrollPane scrollPane;
    private File defaultImageDirectory;
    private ViewletTracker viewletTracker;

    public DesktopViewer(VisClientStateModel visClientStateModel, Viewable viewable) {
        super(visClientStateModel, viewable);
        this.setDescription("Desktop viewer");
        this.viewletFactories = new LinkedList();
        this.indexToViewlets = new HashMap();
        this.allViewlets = new HashSet();
        this.addMenuItem("Background", new ImportBackgroundAction(this));
    }

    private void addNewViewletComponent(Viewlet viewlet, int n, int n2) {
        JViewport jViewport = this.scrollPane.getViewport();
        Dimension dimension = viewlet.getComponent().getPreferredSize();
        if (viewlet.getComponent() instanceof Zoomable) {
            ((Zoomable)((Object)viewlet.getComponent())).zoomToLevel(this.viewletDesktop.getZoomLevel());
        }
        int n3 = jViewport.getWidth() < this.viewletDesktop.getDesktopSize().width ? jViewport.getViewPosition().x + (jViewport.getWidth() / 2 - dimension.width / 2) : this.viewletDesktop.getDesktopSize().width / 2 - dimension.width / 2;
        int n4 = jViewport.getHeight() < this.viewletDesktop.getDesktopSize().height ? jViewport.getViewPosition().y + (jViewport.getHeight() / 2 - dimension.height / 2) : this.viewletDesktop.getDesktopSize().height / 2 - dimension.height / 2;
        this.clearSelection();
        this.addToSelection(viewlet);
        this.viewletDesktop.addNewViewletComponent(viewlet, n3 += dimension.width * n, n4 += dimension.height * n2);
    }

    public void addViewletFactory(ViewletFactory viewletFactory) {
        if (viewletFactory.canBuildFrom(this.getViewable().getType().getElementType())) {
            this.viewletFactories.add(viewletFactory);
            SymRef symRef = new SymRef(viewletFactory, this.getSymRef(), viewletFactory.getDescription());
            viewletFactory.setSymRef(symRef);
            this.addMenuItem("Insert", new AddViewletAction(this, viewletFactory));
        }
    }

    void bringViewletsToTopPrivate(Collection collection) {
        this.viewletDesktop.bringViewletsToTopPrivate(collection);
    }

    protected Collection getAllViewlets() {
        return this.allViewlets;
    }

    public Component getComponent() {
        return this.scrollPane;
    }

    protected ViewletTracker getViewletTracker() {
        return this.viewletTracker;
    }

    protected Collection getViewletsAt(List list) {
        Collection collection = (Collection)this.indexToViewlets.get(list);
        if (collection == null) {
            collection = Collections.EMPTY_LIST;
        }
        return collection;
    }

    protected Action getZoomToFitHeightAction() {
        return new ZoomToFitHeightAction(this);
    }

    protected Action getZoomToFitWidthAction() {
        return new ZoomToFitWidthAction(this);
    }

    void importBackgroundImage(File file) {
        Image image = Toolkit.getDefaultToolkit().getImage(file.toString());
        MediaTracker mediaTracker = new MediaTracker(this.viewletDesktop);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {}
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = new BufferedImage(image.getWidth(this.viewletDesktop), image.getHeight(this.viewletDesktop), 4);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getComponent(), "Image could not be loaded from file \n" + file.toString(), "Error in Visualisation Client", 0);
            return;
        }
        bufferedImage.createGraphics().drawImage(image, 0, 0, this.viewletDesktop);
        this.viewletDesktop.setBackgroundImage(bufferedImage);
    }

    private void initialiseComponent() {
        this.viewletDesktop = new ViewletDesktop(this);
        MouseViewletSelector mouseViewletSelector = new MouseViewletSelector(this, this.viewletDesktop);
        SingleViewletSelector singleViewletSelector = new SingleViewletSelector(this, this.viewletDesktop);
        MouseViewletMover mouseViewletMover = new MouseViewletMover(this.viewletDesktop, this.getSelection());
        MouseViewletMenuUpPopper mouseViewletMenuUpPopper = new MouseViewletMenuUpPopper(this, this.viewletDesktop);
        this.scrollPane = new JScrollPane(this.viewletDesktop);
        this.viewletTracker = new ViewletTracker(this.scrollPane);
    }

    void insertNewViewlet(ViewletFactory viewletFactory, int[][] nArray) {
        int n;
        Viewlet viewlet = viewletFactory.build();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray.length) {
            nArray2[n5] = nArray[n5].length - 1;
            if (nArray[n5].length > 1) {
                switch (++n4) {
                    case 1: {
                        n2 = n5;
                        break;
                    }
                    case 2: {
                        n3 = n5;
                        break;
                    }
                }
            }
            ++n5;
        }
        int n6 = nArray.length;
        int n7 = 0;
        do {
            int n8;
            if (n6 > nArray.length - 1) {
                n8 = 0;
                int n9 = 0;
                arrayList.clear();
                int n10 = 0;
                while (n10 < nArray.length) {
                    arrayList.add(new Integer(nArray[n10][nArray2[n10]]));
                    if (n10 == n2) {
                        n9 = nArray2[n10];
                    }
                    if (n10 == n3) {
                        n8 = nArray2[n10];
                    }
                    ++n10;
                }
                this.insertNewViewletAt(viewletFactory, new ArrayList(arrayList), n9, n8);
                ++n7;
                --n6;
            }
            n = 0;
            n8 = 0;
            while (n8 < nArray.length) {
                n += nArray2[n8];
                ++n8;
            }
            if (n == 0) break;
            int n11 = n6;
            nArray2[n11] = nArray2[n11] - 1;
            if (nArray2[n6] < 0) {
                nArray2[n6] = nArray[n6].length;
                --n6;
                continue;
            }
            ++n6;
        } while (n > 0);
    }

    void insertNewViewletAt(ViewletFactory viewletFactory, List list, int n, int n2) {
        CompoundTermImpl compoundTermImpl;
        Viewlet viewlet = viewletFactory.build();
        CompoundTermImpl compoundTermImpl2 = new CompoundTermImpl("element", (Object)list);
        viewlet.setElementReference(compoundTermImpl2);
        CompoundTerm compoundTerm = viewlet.collectPreBuildGoal();
        try {
            compoundTermImpl = (CompoundTermImpl)this.getStateModel().executeInEventGoal(this.composeElementGoal(compoundTermImpl2, compoundTerm));
        }
        catch (VisException visException) {
            throw new RuntimeException("VisException " + visException + " thrown while running " + "viewlet's pre-build goal");
        }
        viewlet.startBuild((CompoundTerm)compoundTermImpl.argCT(2).arg(3));
        LinkedList<Viewlet> linkedList = (LinkedList<Viewlet>)this.indexToViewlets.get(list);
        if (linkedList == null) {
            linkedList = new LinkedList<Viewlet>();
        }
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>(list);
        linkedList2.add(new Integer(linkedList.size()));
        viewlet.setSymRef(new SymRef(viewlet, this.getSymRef(), linkedList2));
        linkedList.add(viewlet);
        this.allViewlets.add(viewlet);
        this.indexToViewlets.put(list, linkedList);
        this.addNewViewletComponent(viewlet, n, n2);
    }

    void moveViewlets(int n, int n2, Collection collection) {
        this.viewletDesktop.moveViewlets(n, n2, collection);
    }

    private void removeShrunkenViewlets() {
        LinkedList linkedList = new LinkedList(this.indexToViewlets.keySet());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            if (this.within(list, this.getSize())) continue;
            this.viewletDesktop.removeViewletComponents((Collection)this.indexToViewlets.get(list));
            this.indexToViewlets.remove(list);
        }
    }

    public void startEvent(VisEvent visEvent, List list) {
        super.startEvent(visEvent, list);
        if (visEvent instanceof CreateEvent) {
            this.initialiseComponent();
        }
    }

    public void stopEvent() {
        if (this.getCurrentEvent() instanceof ContractEvent) {
            this.removeShrunkenViewlets();
        }
        super.stopEvent();
    }

    private boolean within(List list, List list2) {
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            if (((Integer)iterator.next()).compareTo((Integer)iterator2.next()) <= 0) continue;
            return false;
        }
        return true;
    }

    public void zoomToLevel(float f) {
        this.viewletDesktop.zoomToLevel(f);
        this.scrollPane.revalidate();
    }

    private class AddViewletAction
    extends AbstractAction
    implements PropertyChangeListener {
        ViewletFactory viewletFactory;
        DesktopViewer viewer;
        boolean destroyed = false;

        public AddViewletAction(DesktopViewer desktopViewer2, ViewletFactory viewletFactory) {
            super("Insert " + viewletFactory.getDescription().toLowerCase());
            this.viewletFactory = viewletFactory;
            this.viewer = desktopViewer2;
            this.setEnabled(DesktopViewer.this.getStateModel().getEclipseHasControl() ^ true);
            DesktopViewer.this.getStateModel().getPropertyChangeSupport().addPropertyChangeListener("eclipseHasControl", this);
            DesktopViewer.this.getPropertyChangeSupport().addPropertyChangeListener("destroyEventIssued", this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LinkedList<List> linkedList = new LinkedList<List>();
            int n = 1;
            while (n <= DesktopViewer.this.getSize().size()) {
                linkedList.add(DesktopViewer.this.getLocationNames(n));
                ++n;
            }
            IndexChoosingDialog indexChoosingDialog = new IndexChoosingDialog(DesktopViewer.this.getViewable().getNameAtom(), linkedList, this.viewletFactory, this.viewer);
            indexChoosingDialog.show();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("destroyEventIssued")) {
                this.destroyed = true;
            }
            if (this.destroyed || ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class IndexChoosingDialog
    extends JDialog {
        private ViewletFactory viewletFactory;
        private DesktopViewer viewer;
        private InsertAction insertAction;
        private JList[] locationSelection;

        public IndexChoosingDialog(Object object, List list, ViewletFactory viewletFactory, DesktopViewer desktopViewer2) {
            this.setModal(true);
            this.setTitle("New " + viewletFactory.getDescription().toLowerCase());
            this.viewletFactory = viewletFactory;
            this.viewer = desktopViewer2;
            this.insertAction = new InsertAction();
            this.initialiseLocationSelectors(list);
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.getContentPane().add((Component)this.locationSelectorPanel(), gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 0;
            this.getContentPane().add((Component)new JLabel("Select viewable element location"), gridBagConstraints);
            gridBagConstraints.gridy = 2;
            JPanel jPanel = new JPanel();
            jPanel.add(new ActionButton(this.insertAction));
            jPanel.add(new ActionButton(new CancelAction()));
            this.getContentPane().add((Component)jPanel, gridBagConstraints);
            this.pack();
        }

        private void addViewlets() {
            int[][] nArray = new int[this.locationSelection.length][];
            int n = 0;
            while (n < this.locationSelection.length) {
                nArray[n] = this.locationSelection[n].getSelectedIndices();
                int n2 = 0;
                while (n2 < nArray[n].length) {
                    int[] nArray2 = nArray[n];
                    int n3 = n2++;
                    nArray2[n3] = nArray2[n3] + 1;
                }
                ++n;
            }
            new DesktopViewerInsertViewletCommand(this.viewer, nArray, this.viewletFactory).issue();
        }

        private void initialiseLocationSelectors(List list) {
            Iterator iterator = list.iterator();
            this.locationSelection = new JList[list.size()];
            int n = 0;
            while (iterator.hasNext()) {
                List list2 = (List)iterator.next();
                this.locationSelection[n] = new JList(new Vector(list2));
                this.locationSelection[n].setSelectionMode(2);
                this.locationSelection[n].setVisibleRowCount(6);
                this.locationSelection[n].addListSelectionListener(this.insertAction);
                if (list2.size() == 1) {
                    this.locationSelection[n].setSelectedIndex(0);
                    this.locationSelection[n].setEnabled(false);
                }
                ++n;
            }
        }

        private JPanel locationSelectorPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel jPanel = new JPanel(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.gridx = 0;
            int n = 0;
            while (n < this.locationSelection.length) {
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridy = 0;
                jPanel.add((Component)new JLabel("Dimension " + (n + 1)), gridBagConstraints);
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridy = 1;
                jPanel.add((Component)new JScrollPane(this.locationSelection[n]), gridBagConstraints);
                ++gridBagConstraints.gridx;
                ++n;
            }
            return jPanel;
        }

        private class InsertAction
        extends AbstractAction
        implements ListSelectionListener {
            InsertAction() {
                super("Insert");
                this.setEnabled(false);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                IndexChoosingDialog.this.addViewlets();
                IndexChoosingDialog.this.dispose();
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = true;
                int n = 0;
                while (n < IndexChoosingDialog.this.locationSelection.length) {
                    if (IndexChoosingDialog.this.locationSelection[n] == null || IndexChoosingDialog.this.locationSelection[n].getMinSelectionIndex() < 0) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
                if (bl) {
                    this.setEnabled(true);
                }
            }
        }

        private class CancelAction
        extends AbstractAction {
            CancelAction() {
                super("Cancel");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                IndexChoosingDialog.this.dispose();
            }
        }
    }

    private class SingleViewletSelector
    extends MouseViewletSelector {
        public SingleViewletSelector(ContainerViewer containerViewer, ViewletSelectable viewletSelectable) {
            super(containerViewer, viewletSelectable);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ViewletSelectable viewletSelectable;
            Viewlet viewlet;
            if ((mouseEvent.getModifiers() & 0x10) == 16 && (viewlet = (viewletSelectable = (ViewletSelectable)mouseEvent.getSource()).pixelPointToViewlet(mouseEvent.getX(), mouseEvent.getY())) != null && !viewlet.getSelected()) {
                this.selectSingle(viewletSelectable, mouseEvent, viewlet);
                viewletSelectable.selectSingleViewlet(viewlet);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        private void selectSingle(ViewletSelectable viewletSelectable, MouseEvent mouseEvent, Viewlet viewlet) {
            this.containerViewer.clearSelection();
            if (viewlet != null) {
                this.containerViewer.addToSelection(viewlet);
            }
            viewletSelectable.selectSingleViewlet(viewlet);
            if (mouseEvent.getSource() instanceof Component) {
                ((Component)mouseEvent.getSource()).requestFocus();
            }
        }
    }

    private class ImportBackgroundAction
    extends AbstractAction {
        private DesktopViewer desktopViewer;

        ImportBackgroundAction(DesktopViewer desktopViewer2) {
            super("Import background image");
            this.desktopViewer = desktopViewer2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            ImageFileChooser imageFileChooser = new ImageFileChooser();
            if (DesktopViewer.this.defaultImageDirectory != null) {
                imageFileChooser.setCurrentDirectory(DesktopViewer.this.defaultImageDirectory);
            }
            if ((n = imageFileChooser.showOpenDialog(DesktopViewer.this.getComponent())) == 0) {
                if (imageFileChooser.getSelectedFile().exists()) {
                    new DesktopViewerImportBackgroundCommand(this.desktopViewer, imageFileChooser.getSelectedFile()).issue();
                } else {
                    JOptionPane.showMessageDialog(DesktopViewer.this.getComponent(), "File \n" + imageFileChooser.getSelectedFile().toString() + "\ndoes not exist", "Error in Visualisation Client", 0);
                }
            }
            DesktopViewer.this.defaultImageDirectory = imageFileChooser.getCurrentDirectory();
        }
    }

    private class ImageFileFilter
    extends FileFilter {
        ImageFileFilter() {
        }

        public boolean accept(File file) {
            return file.toString().endsWith(".gif") || file.toString().endsWith(".GIF") || file.isDirectory();
        }

        public String getDescription() {
            return "GIF image";
        }
    }

    private class ImageFileChooser
    extends JFileChooser
    implements PropertyChangeListener {
        ImageFileChooser() {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            this.setFileSelectionMode(0);
            this.setFileFilter(new ImageFileFilter());
            ((Component)this).addPropertyChangeListener("directoryChanged", this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setSelectedFile(null);
        }
    }

    private class ZoomToFitWidthAction
    extends AbstractAction {
        Viewer viewer;

        ZoomToFitWidthAction(Viewer viewer) {
            super("Zoom to fit width");
            this.viewer = viewer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = DesktopViewer.this.scrollPane.getViewport().getWidth();
            int n2 = ((DesktopViewer)DesktopViewer.this).viewletDesktop.getNormalSize().width;
            float f = (float)n / (float)n2;
            new ViewerZoomCommand(this.viewer, f).issue();
        }
    }

    private class ZoomToFitHeightAction
    extends AbstractAction {
        Viewer viewer;

        ZoomToFitHeightAction(Viewer viewer) {
            super("Zoom to fit height");
            this.viewer = viewer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = DesktopViewer.this.scrollPane.getViewport().getHeight();
            int n2 = ((DesktopViewer)DesktopViewer.this).viewletDesktop.getNormalSize().height;
            float f = (float)n / (float)n2;
            new ViewerZoomCommand(this.viewer, f).issue();
        }
    }
}

