/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.DesktopViewerFactory;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewerBuildingPolicy;
import com.parctechnologies.eclipse.visualisation.ViewerFactory;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.viewers.BoundsTableViewerFactory;
import com.parctechnologies.eclipse.visualisation.viewers.TextTableViewerFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DefaultViewerBuildingPolicy
implements ViewerBuildingPolicy {
    private Map factories;
    private Map enabled;
    private ViewerFactory textTableViewerFactory;
    private ViewerFactory boundsTableViewerFactory;
    private ViewerFactory desktopViewerFactory;
    private VisClientStateModel stateModel;

    DefaultViewerBuildingPolicy(VisClientStateModel visClientStateModel) {
        this.stateModel = visClientStateModel;
        this.factories = new HashMap();
        this.enabled = new HashMap();
        this.factories.put("TextTable", new TextTableViewerFactory(visClientStateModel));
        this.enabled.put("TextTable", new Boolean(true));
        this.factories.put("BoundsTable", new BoundsTableViewerFactory(visClientStateModel));
        this.enabled.put("BoundsTable", new Boolean(true));
        this.factories.put("Desktop", new DesktopViewerFactory(visClientStateModel));
        this.enabled.put("Desktop", new Boolean(true));
    }

    public Set availableViewerFactories() {
        return this.factories.keySet();
    }

    public List buildViewers(Viewable viewable) {
        LinkedList<Viewer> linkedList = new LinkedList<Viewer>();
        Iterator iterator = this.availableViewerFactories().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ViewerFactory viewerFactory = (ViewerFactory)this.factories.get(e);
            if (!((Boolean)this.enabled.get(e)).booleanValue() || !viewerFactory.canBuildFrom(viewable.getType())) continue;
            linkedList.add(viewerFactory.build(viewable));
        }
        return linkedList;
    }

    public void enableViewers(List list) {
        Iterator iterator = this.factories.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (list.contains(k)) {
                this.enabled.put(k, new Boolean(true));
                continue;
            }
            this.enabled.put(k, new Boolean(false));
        }
        this.stateModel.setViewerBuildingPolicySelected(true);
    }
}

