/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.visualisation.BatchGoal;
import com.parctechnologies.eclipse.visualisation.BooleanPropertyModel;
import com.parctechnologies.eclipse.visualisation.ContractEvent;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.ExpandEvent;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewerImpl;
import com.parctechnologies.eclipse.visualisation.ViewerSetBooleanPropertyCommand;
import com.parctechnologies.eclipse.visualisation.ViewerSetSelectionCommand;
import com.parctechnologies.eclipse.visualisation.ViewerZoomCommand;
import com.parctechnologies.eclipse.visualisation.Viewlet;
import com.parctechnologies.eclipse.visualisation.ViewletSelection;
import com.parctechnologies.eclipse.visualisation.ViewletTracker;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import java.awt.event.ActionEvent;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.SwingUtilities;

public abstract class ContainerViewer
extends ViewerImpl {
    private List createdElementIndices;
    private List updatingElementIndices;
    private List expandingElementIndices;
    private Collection createdViewlets;
    private Collection updatingViewlets;
    private Collection expandingViewlets;
    private List size;
    private boolean trackUpdates = false;
    private SelectUpdatingAction selectUpdatingAction;
    private static final Atom vcSupportAtom = new Atom("vc_support");
    protected LinkedList selectionCopy = new LinkedList();
    protected ViewletSelection selection = new ViewletSelection();
    private List[] locationNames;

    public ContainerViewer(VisClientStateModel visClientStateModel, Viewable viewable) {
        super(visClientStateModel, viewable);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Track updates");
        ((AbstractButton)jCheckBoxMenuItem).setModel(new BooleanPropertyModel("trackUpdates", this, this.getPropertyChangeSupport()));
        this.addMenuItem("Options", jCheckBoxMenuItem);
        this.addMenuItem("Select", new SelectAllAction());
        this.selectUpdatingAction = new SelectUpdatingAction();
        this.addMenuItem("Select", this.selectUpdatingAction);
        this.addMenuItem("Select", new ClearSelectionAction());
        this.addMenuItem("View", this.getZoomAction(this, 4.0f));
        this.addMenuItem("View", this.getZoomAction(this, 2.0f));
        this.addMenuItem("View", this.getZoomAction(this, 1.5f));
        this.addMenuItem("View", this.getZoomNormalAction(this));
        this.addMenuItem("View", this.getZoomAction(this, 0.75f));
        this.addMenuItem("View", this.getZoomAction(this, 0.5f));
        this.addMenuItem("View", this.getZoomAction(this, 0.25f));
        this.addMenuItem("View", this.getZoomToFitWidthAction());
        this.addMenuItem("View", this.getZoomToFitHeightAction());
    }

    public void addAllToSelection(Collection collection) {
        HashSet hashSet = new HashSet(this.selection);
        hashSet.addAll(collection);
        this.setSelection(collection);
    }

    private void addAllToSelectionPrivate(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addToSelectionPrivate((Viewlet)iterator.next());
        }
    }

    public void addToSelection(Viewlet viewlet) {
        LinkedList<Viewlet> linkedList = new LinkedList<Viewlet>();
        linkedList.add(viewlet);
        this.addAllToSelection(linkedList);
    }

    private void addToSelectionPrivate(Viewlet viewlet) {
        this.selection.add(viewlet);
        viewlet.setSelected(true);
    }

    protected List allCombinations(List list) {
        LinkedList linkedList = new LinkedList();
        if (list.size() > 0) {
            Integer n = (Integer)list.get(0);
            List list2 = list.subList(1, list.size());
            List list3 = this.allCombinations(list2);
            int n2 = 1;
            while (n2 <= n) {
                Iterator iterator = list3.iterator();
                while (iterator.hasNext()) {
                    LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
                    linkedList2.add(new Integer(n2));
                    linkedList2.addAll((List)iterator.next());
                    linkedList.add(linkedList2);
                }
                ++n2;
            }
        } else {
            linkedList.add(new LinkedList());
        }
        return linkedList;
    }

    public void clearSelection() {
        this.setSelection(Collections.EMPTY_LIST);
    }

    private Collection collectPreBuildGoals(List list) {
        BatchGoal batchGoal = new BatchGoal();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            Collection collection = this.getViewletsAt(list2);
            batchGoal.add(this.composeElementBuildGoal(collection, list2));
        }
        return batchGoal;
    }

    public BatchGoal collectPreEventGoals(VisEvent visEvent) {
        BatchGoal batchGoal = new BatchGoal();
        if (visEvent instanceof UpdateEvent) {
            batchGoal.add(super.collectPreEventGoals(visEvent));
            this.setUpdatingElementIndices((UpdateEvent)visEvent);
            batchGoal.add(this.collectPreUpdateGoals(this.updatingElementIndices, (UpdateEvent)visEvent));
            return batchGoal;
        }
        if (visEvent instanceof ExpandEvent) {
            batchGoal.add(super.collectPreEventGoals(visEvent));
            ExpandEvent expandEvent = (ExpandEvent)visEvent;
            int n = expandEvent.getExpandingDimension();
            Integer n2 = (Integer)expandEvent.getViewableSize().get(n - 1);
            batchGoal.add(this.getAddLocationNameGoal(n, n2));
            this.setExpandingElementIndices(expandEvent);
            batchGoal.add(this.collectPreBuildGoals(this.expandingElementIndices));
            return batchGoal;
        }
        if (visEvent instanceof CreateEvent) {
            batchGoal.add(super.collectPreEventGoals(visEvent));
            CreateEvent createEvent = (CreateEvent)visEvent;
            int n = 1;
            while (n <= createEvent.getViewableSize().size()) {
                batchGoal.add(this.getLocationNamesGoal(n));
                ++n;
            }
            this.setCreatedElementIndices(createEvent);
            batchGoal.add(this.collectPreBuildGoals(this.createdElementIndices));
            return batchGoal;
        }
        return super.collectPreEventGoals(visEvent);
    }

    private Collection collectPreUpdateGoals(List list, UpdateEvent updateEvent) {
        BatchGoal batchGoal = new BatchGoal();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            Collection collection = this.getViewletsAt(list2);
            batchGoal.add(this.composeElementUpdateGoal(collection, list2, updateEvent));
        }
        return batchGoal;
    }

    private BatchGoal composeElementBuildGoal(Collection collection, List list) {
        BatchGoal batchGoal = new BatchGoal();
        CompoundTermImpl compoundTermImpl = new CompoundTermImpl("element", (Object)list);
        Iterator iterator = collection.iterator();
        Atom atom = this.getViewable().getNameAtom();
        while (iterator.hasNext()) {
            Viewlet viewlet = (Viewlet)iterator.next();
            CompoundTerm compoundTerm = viewlet.collectPreBuildGoal();
            batchGoal.add(this.composeElementGoal(compoundTermImpl, compoundTerm));
        }
        return batchGoal;
    }

    protected CompoundTerm composeElementGoal(Object object, CompoundTerm compoundTerm) {
        return new CompoundTermImpl(":", (Object)vcSupportAtom, (Object)new CompoundTermImpl("viewable_element_execute", (Object)this.getViewable().getNameAtom(), object, (Object)compoundTerm));
    }

    private BatchGoal composeElementUpdateGoal(Collection collection, List list, UpdateEvent updateEvent) {
        BatchGoal batchGoal = new BatchGoal();
        CompoundTermImpl compoundTermImpl = new CompoundTermImpl("element", (Object)list);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Viewlet viewlet = (Viewlet)iterator.next();
            CompoundTerm compoundTerm = viewlet.collectPreUpdateGoal(updateEvent);
            batchGoal.add(this.composeElementGoal(compoundTermImpl, compoundTerm));
        }
        return batchGoal;
    }

    private void distributeBuildResult(List list, Collection collection) {
        Iterator iterator = list.iterator();
        Iterator iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            Viewlet viewlet = (Viewlet)iterator2.next();
            Object e = iterator.next();
            CompoundTermImpl compoundTermImpl = (CompoundTermImpl)e;
            viewlet.startBuild((CompoundTerm)compoundTermImpl.argCT(2).arg(3));
        }
    }

    private void distributeBuildResults(List list, List list2) {
        Iterator iterator = list2.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            List list3 = (List)iterator.next();
            Collection collection = this.getViewletsAt(list3);
            List list4 = (List)iterator2.next();
            this.distributeBuildResult(list4, collection);
        }
    }

    private void distributeUpdateResult(List list, Collection collection, UpdateEvent updateEvent) {
        Iterator iterator = list.iterator();
        Iterator iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            Viewlet viewlet = (Viewlet)iterator2.next();
            CompoundTermImpl compoundTermImpl = (CompoundTermImpl)iterator.next();
            viewlet.startUpdate(updateEvent, (CompoundTerm)compoundTermImpl.argCT(2).arg(3));
        }
    }

    private void distributeUpdateResults(List list, List list2, UpdateEvent updateEvent) {
        Iterator iterator = list2.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            List list3 = (List)iterator.next();
            Collection collection = this.getViewletsAt(list3);
            List list4 = (List)iterator2.next();
            this.distributeUpdateResult(list4, collection, updateEvent);
        }
    }

    public void gainFocus() {
        super.gainFocus();
        this.setSelection(this.selectionCopy);
        this.getComponent().repaint();
    }

    private CompoundTerm getAddLocationNameGoal(int n, int n2) {
        CompoundTermImpl compoundTermImpl = new CompoundTermImpl(":", (Object)vcSupportAtom, (Object)new CompoundTermImpl("viewable_get_location_name", (Object)this.getViewable().getNameAtom(), (Object)new Integer(n), (Object)new Integer(n2), null));
        return compoundTermImpl;
    }

    protected abstract Collection getAllViewlets();

    protected Collection getCreatedElementIndices() {
        return this.createdElementIndices;
    }

    public Collection getCreatedViewlets() {
        if (this.createdViewlets == null) {
            this.createdViewlets = this.getViewletsAtIndexList(this.getCreatedElementIndices());
        }
        return this.createdViewlets;
    }

    protected Collection getExpandingElementIndices() {
        return this.expandingElementIndices;
    }

    public Collection getExpandingViewlets() {
        if (this.expandingViewlets == null) {
            this.expandingViewlets = this.getViewletsAtIndexList(this.getExpandingElementIndices());
        }
        return this.expandingViewlets;
    }

    protected String getLocationName(int n, int n2) {
        return (String)this.getLocationNames(n).get(n2 - 1);
    }

    protected List getLocationNames(int n) {
        return this.locationNames[n - 1];
    }

    private CompoundTerm getLocationNamesGoal(int n) {
        CompoundTermImpl compoundTermImpl = new CompoundTermImpl(":", (Object)vcSupportAtom, (Object)new CompoundTermImpl("viewable_get_location_names", (Object)this.getViewable().getNameAtom(), (Object)new Integer(n), null));
        return compoundTermImpl;
    }

    public ViewletSelection getSelection() {
        return this.selection;
    }

    protected List getSize() {
        return this.size;
    }

    public boolean getTrackUpdates() {
        return this.trackUpdates;
    }

    protected Collection getUpdatingElementIndices() {
        return this.updatingElementIndices;
    }

    public Collection getUpdatingViewlets() {
        if (this.updatingViewlets == null) {
            this.updatingViewlets = this.getViewletsAtIndexList(this.getUpdatingElementIndices());
        }
        return this.updatingViewlets;
    }

    protected abstract ViewletTracker getViewletTracker();

    protected abstract Collection getViewletsAt(List var1);

    private Collection getViewletsAtIndexList(Collection collection) {
        Iterator iterator = collection.iterator();
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Collection collection2 = this.getViewletsAt(list);
            linkedList.addAll(collection2);
        }
        return linkedList;
    }

    protected Action getZoomAction(Viewer viewer, float f) {
        return new ZoomAction(viewer, f);
    }

    protected Action getZoomNormalAction(Viewer viewer) {
        return new ZoomNormalAction(viewer);
    }

    protected abstract Action getZoomToFitHeightAction();

    protected abstract Action getZoomToFitWidthAction();

    private String locationNameFromGoalResult(CompoundTermImpl compoundTermImpl) {
        return (String)compoundTermImpl.argCT(2).arg(4);
    }

    private List locationNamesFromGoalResult(CompoundTermImpl compoundTermImpl) {
        return (List)compoundTermImpl.argCT(2).arg(3);
    }

    public void loseFocus() {
        super.loseFocus();
        this.selectionCopy = new LinkedList(this.getSelection());
        this.clearSelection();
        this.getComponent().repaint();
    }

    public void removeAllFromSelection(Collection collection) {
        HashSet hashSet = new HashSet(this.selection);
        ((AbstractCollection)hashSet).removeAll(collection);
        this.setSelection(hashSet);
    }

    private void removeAllFromSelectionPrivate(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeFromSelectionPrivate((Viewlet)iterator.next());
        }
    }

    public void removeFromSelection(Viewlet viewlet) {
        LinkedList<Viewlet> linkedList = new LinkedList<Viewlet>();
        linkedList.add(viewlet);
        this.removeAllFromSelection(linkedList);
    }

    private void removeFromSelectionPrivate(Viewlet viewlet) {
        this.selection.remove(viewlet);
        viewlet.setSelected(false);
    }

    private void scrollToTrackUpdate(Collection collection) {
        ViewletTracker viewletTracker = this.getViewletTracker();
        viewletTracker.setViewlets(this.getUpdatingViewlets());
        try {
            SwingUtilities.invokeAndWait(viewletTracker);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception " + exception + " thrown " + "while executing viewletTracker");
        }
    }

    private void setCreatedElementIndices(CreateEvent createEvent) {
        List list = createEvent.getViewableSize();
        this.createdElementIndices = this.allCombinations(list);
    }

    private void setExpandingElementIndices(ExpandEvent expandEvent) {
        LinkedList<List> linkedList = new LinkedList<List>();
        int n = expandEvent.getExpandingDimension();
        Integer n2 = (Integer)expandEvent.getViewableSize().get(n - 1);
        LinkedList linkedList2 = new LinkedList(expandEvent.getViewableSize());
        linkedList2.remove(n - 1);
        List list = this.allCombinations(linkedList2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            list2.add(n - 1, n2);
            linkedList.add(list2);
        }
        this.expandingElementIndices = linkedList;
    }

    public void setSelection(Collection collection) {
        new ViewerSetSelectionCommand(this, collection).issue();
    }

    void setSelectionPrivate(Collection collection) {
        Viewlet viewlet;
        LinkedList<Viewlet> linkedList = new LinkedList<Viewlet>();
        LinkedList<Viewlet> linkedList2 = new LinkedList<Viewlet>();
        Iterator iterator = this.selection.iterator();
        while (iterator.hasNext()) {
            viewlet = (Viewlet)iterator.next();
            if (collection.contains(viewlet)) continue;
            linkedList2.add(viewlet);
        }
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            viewlet = (Viewlet)iterator2.next();
            if (this.selection.contains(viewlet)) continue;
            linkedList.add(viewlet);
        }
        this.addAllToSelectionPrivate(linkedList);
        this.removeAllFromSelectionPrivate(linkedList2);
    }

    public void setTrackUpdates(boolean bl) {
        new ViewerSetBooleanPropertyCommand(this, "trackUpdates", bl).issue();
    }

    public void setTrackUpdatesPrivate(boolean bl) {
        boolean bl2 = this.trackUpdates;
        this.trackUpdates = bl;
        this.getPropertyChangeSupport().firePropertyChange("trackUpdates", bl2, bl);
    }

    private void setUpdatingElementIndices(UpdateEvent updateEvent) {
        this.updatingElementIndices = updateEvent.getElementsUpdating();
    }

    public boolean shouldHold() {
        if (super.shouldHold()) {
            return true;
        }
        if (this.getCurrentEvent() instanceof UpdateEvent) {
            Collection collection = this.getUpdatingViewlets();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Viewlet viewlet = (Viewlet)iterator.next();
                if (!viewlet.getHoldsOnUpdates()) continue;
                return true;
            }
        }
        return false;
    }

    private void shrinkLocationNamesTo(List list) {
        int n = 0;
        while (n < this.locationNames.length) {
            List list2;
            int n2 = (Integer)list.get(n);
            this.locationNames[n] = list2 = this.locationNames[n].subList(0, n2);
            ++n;
        }
    }

    public void startEvent(VisEvent visEvent, List list) {
        if (visEvent instanceof UpdateEvent) {
            super.startEvent(visEvent, (List)list.get(0));
            this.distributeUpdateResults((List)list.get(1), this.updatingElementIndices, (UpdateEvent)visEvent);
            this.selectUpdatingAction.setEnabled(true);
            if (this.trackUpdates) {
                this.scrollToTrackUpdate(this.getUpdatingViewlets());
            }
            return;
        }
        this.selectUpdatingAction.setEnabled(false);
        if (visEvent instanceof ExpandEvent) {
            this.size = ((ExpandEvent)visEvent).getViewableSize();
            super.startEvent(visEvent, (List)list.get(0));
            String string = this.locationNameFromGoalResult((CompoundTermImpl)list.get(1));
            int n = ((ExpandEvent)visEvent).getExpandingDimension();
            this.locationNames[n - 1].add(string);
            this.distributeBuildResults((List)list.get(2), this.expandingElementIndices);
            return;
        }
        if (visEvent instanceof ContractEvent) {
            this.size = ((ContractEvent)visEvent).getViewableSize();
            this.shrinkLocationNamesTo(this.size);
        }
        if (visEvent instanceof CreateEvent) {
            this.size = ((CreateEvent)visEvent).getViewableSize();
            super.startEvent(visEvent, (List)list.get(0));
            int n = this.size.size();
            this.locationNames = new List[n];
            int n2 = 1;
            while (n2 <= n) {
                List list2;
                this.locationNames[n2 - 1] = list2 = this.locationNamesFromGoalResult((CompoundTermImpl)list.get(n2));
                ++n2;
            }
            this.distributeBuildResults((List)list.get(n2), this.createdElementIndices);
            return;
        }
        super.startEvent(visEvent, list);
    }

    private void stopBuild(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            Iterator iterator2 = this.getViewletsAt(list2).iterator();
            while (iterator2.hasNext()) {
                Viewlet viewlet = (Viewlet)iterator2.next();
                viewlet.stopBuild();
            }
        }
    }

    public void stopEvent() {
        if (this.getCurrentEvent() instanceof CreateEvent) {
            this.stopBuild(this.createdElementIndices);
        }
        if (this.getCurrentEvent() instanceof ExpandEvent) {
            this.stopBuild(this.expandingElementIndices);
        }
        if (this.getCurrentEvent() instanceof UpdateEvent) {
            this.stopUpdate(this.updatingElementIndices);
            this.selectUpdatingAction.setEnabled(false);
        }
        this.createdElementIndices = null;
        this.updatingElementIndices = null;
        this.expandingElementIndices = null;
        this.createdViewlets = null;
        this.updatingViewlets = null;
        this.expandingViewlets = null;
        super.stopEvent();
    }

    private void stopUpdate(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            Iterator iterator2 = this.getViewletsAt(list2).iterator();
            while (iterator2.hasNext()) {
                Viewlet viewlet = (Viewlet)iterator2.next();
                viewlet.stopUpdate();
            }
        }
    }

    private abstract class ViewletSelectionAction
    extends AbstractAction {
        ViewletSelectionAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContainerViewer.this.clearSelection();
            ContainerViewer.this.addAllToSelection(this.newSelection());
            ContainerViewer.this.getComponent().repaint();
        }

        protected abstract Collection newSelection();
    }

    private class SelectAllAction
    extends ViewletSelectionAction {
        SelectAllAction() {
            super("Select all viewlets");
        }

        protected Collection newSelection() {
            return ContainerViewer.this.getAllViewlets();
        }
    }

    private class SelectUpdatingAction
    extends ViewletSelectionAction {
        SelectUpdatingAction() {
            super("Select updating viewlet(s)");
            this.setEnabled(false);
        }

        protected Collection newSelection() {
            return ContainerViewer.this.getUpdatingViewlets();
        }
    }

    private class ClearSelectionAction
    extends ViewletSelectionAction {
        ClearSelectionAction() {
            super("Clear selection");
        }

        protected Collection newSelection() {
            return Collections.EMPTY_LIST;
        }
    }

    private class ZoomAction
    extends AbstractAction {
        private float zoomRatio;
        private Viewer viewer;

        ZoomAction(Viewer viewer, float f) {
            super("Zoom to " + (int)(f * 100.0f) + "%");
            this.zoomRatio = f;
            this.viewer = viewer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new ViewerZoomCommand(this.viewer, this.zoomRatio).issue();
        }
    }

    private class ZoomNormalAction
    extends ZoomAction {
        ZoomNormalAction(Viewer viewer) {
            super(viewer, 1.0f);
            this.putValue("Name", "Zoom to normal size");
        }
    }
}

